/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.XMLPropertyListWriter;
import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.plist.PlistProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class PlistPlaylist
extends AbstractPlaylist {
    private final PlistProvider provider;
    private final NSDictionary plist;

    public PlistPlaylist(PlistProvider provider, NSDictionary plist) {
        this.provider = provider;
        this.plist = plist;
    }

    @Override
    public PlistProvider getProvider() {
        return this.provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        XMLPropertyListWriter.write((NSObject)this.plist, (OutputStream)out);
        out.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        NSDictionary tracks = null;
        NSObject tracksObject = this.plist.objectForKey("Tracks");
        if (tracksObject instanceof NSDictionary) {
            tracks = (NSDictionary)tracksObject;
        }
        NSArray playlists = null;
        NSObject playlistsObject = this.plist.objectForKey("Playlists");
        if (playlistsObject instanceof NSArray) {
            playlists = (NSArray)playlistsObject;
        }
        if (tracks != null && playlists != null) {
            for (NSObject playlistObject : playlists.getArray()) {
                Sequence sequence;
                NSDictionary playlist;
                NSObject playlistItemsArrayObject;
                if (!(playlistObject instanceof NSDictionary) || !((playlistItemsArrayObject = (playlist = (NSDictionary)playlistObject).objectForKey("Playlist Items")) instanceof NSArray)) continue;
                NSArray playlistItemsArray = (NSArray)playlistItemsArrayObject;
                if (playlists.getArray().length > 1) {
                    sequence = new Sequence();
                    ret.getRootSequence().addComponent(sequence);
                } else {
                    sequence = ret.getRootSequence();
                }
                for (NSObject playlistItemsDictObject : playlistItemsArray.getArray()) {
                    String location;
                    NSDictionary track;
                    NSObject locationObject;
                    int trackId;
                    NSObject trackObject;
                    NSObject trackIdObject;
                    if (!(playlistItemsDictObject instanceof NSDictionary) || !((trackIdObject = ((NSDictionary)playlistItemsDictObject).objectForKey("Track ID")) instanceof NSNumber) || !((trackObject = tracks.objectForKey(Integer.toString(trackId = ((NSNumber)trackIdObject).intValue()))) instanceof NSDictionary) || !((locationObject = (track = (NSDictionary)trackObject).objectForKey("Location")) instanceof NSString) || (location = ((NSString)locationObject).getContent()) == null) continue;
                    Media media = new Media();
                    Content content = new Content(location);
                    media.setSource(content);
                    NSObject totalTimeObject = track.objectForKey("Total Time");
                    if (totalTimeObject instanceof NSNumber) {
                        Date dateModified;
                        NSObject dateModifiedObject;
                        try {
                            long totalTime = ((NSNumber)totalTimeObject).longValue();
                            content.setDuration(totalTime);
                        }
                        catch (NumberFormatException totalTime) {
                            // empty catch block
                        }
                        NSObject sizeObject = track.objectForKey("Size");
                        if (sizeObject instanceof NSNumber) {
                            try {
                                long size = ((NSNumber)sizeObject).longValue();
                                if (size >= 0L) {
                                    content.setLength(size);
                                }
                            }
                            catch (NumberFormatException size) {
                                // empty catch block
                            }
                        }
                        if ((dateModifiedObject = track.objectForKey("Date Modified")) instanceof NSDate && (dateModified = ((NSDate)dateModifiedObject).getDate()) != null) {
                            content.setLastModified(dateModified.getTime());
                        }
                    }
                    sequence.addComponent(media);
                }
            }
            ret.normalize();
        }
        return ret;
    }

    public NSDictionary getPlist() {
        return this.plist;
    }
}

