/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.plist;

import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.AbstractPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.plist.PlistPlaylist;
import io.github.borewit.lizzy.xml.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PlistProvider
extends AbstractPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".plist", ".xml"}, new String[]{"text/xml"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.ITUNES, true, null)}, "iTunes Library File")};

    @Override
    public String getId() {
        return "plist";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        NSDictionary plist;
        try {
            plist = (NSDictionary)PropertyListParser.parse((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new PlistPlaylist(this, plist);
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws IOException {
        NSDictionary rootDict = new NSDictionary();
        NSDictionary tracks = new NSDictionary();
        rootDict.put("Tracks", (NSObject)tracks);
        NSDictionary playlistDict = new NSDictionary();
        ArrayList<NSDictionary> playlistEntries = new ArrayList<NSDictionary>();
        playlistEntries.add(playlistDict);
        rootDict.put("Playlists", playlistEntries);
        playlistDict.put("Name", (NSObject)new NSString("Playlist generated by Lizzy v" + Version.CURRENT));
        playlistDict.put("Playlist ID", (NSObject)new NSNumber(System.identityHashCode(playlist.getRootSequence())));
        playlistDict.put("All Items", NSObject.fromJavaObject((Object)true));
        ArrayList<NSDictionary> playlistArray = new ArrayList<NSDictionary>();
        this.addToPlaylist(tracks, playlistArray, playlist.getRootSequence());
        playlistDict.put("Playlist Items", playlistArray);
        return new PlistPlaylist(this, rootDict);
    }

    private void addToPlaylist(NSDictionary tracks, List<NSDictionary> playlistItems, AbstractPlaylistComponent component) {
        block11: {
            block10: {
                if (!(component instanceof Sequence)) break block10;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("A PLIST playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < sequence.getRepeatCount()) {
                    sequence.getComponents().forEach(c -> this.addToPlaylist(tracks, playlistItems, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block11;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A PLIST playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block11;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A PLIST playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("A PLIST playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    NSDictionary entry = new NSDictionary();
                    entry.put("Track ID", (NSObject)new NSNumber(System.identityHashCode(media.getSource())));
                    playlistItems.add(entry);
                    NSDictionary track = new NSDictionary();
                    tracks.put(Integer.toString(System.identityHashCode(media.getSource())), (NSObject)track);
                    track.put("Track ID", (NSObject)new NSNumber(System.identityHashCode(media.getSource())));
                    if (media.getSource().getLength() >= 0L) {
                        track.put("Size", (NSObject)new NSNumber((int)media.getSource().getLength()));
                    }
                    if (media.getSource().getDuration() >= 0L) {
                        track.put("Total Time", (NSObject)new NSNumber((int)media.getSource().getDuration()));
                    }
                    if (media.getSource().getLastModified() > 0L) {
                        track.put("Date Modified", (NSObject)new NSDate(new Date(media.getSource().getLastModified())));
                    }
                    track.put("Location", (NSObject)new NSString(media.getSource().toString()));
                    ++iter;
                }
            }
        }
    }
}

