/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.plp;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.SpecificPlaylistProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class PLP
extends AbstractPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private final List<String> _filenames = new ArrayList<String>();
    private String _diskSpecifier = "HARP";

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-16LE";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, enc));
        writer.write("PLP PLAYLIST");
        writer.write(13);
        writer.write(10);
        writer.write("VERSION 1.20");
        writer.write(13);
        writer.write(10);
        writer.write(13);
        writer.write(10);
        for (String filename : this._filenames) {
            writer.write(this._diskSpecifier);
            writer.write(", ");
            writer.write(filename);
            writer.write(13);
            writer.write(10);
        }
        writer.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (String filename : this._filenames) {
            Media media = new Media();
            Content content = new Content(filename);
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    public List<String> getFilenames() {
        return this._filenames;
    }

    public String getDiskSpecifier() {
        return this._diskSpecifier;
    }

    public void setDiskSpecifier(String diskSpecifier) {
        this._diskSpecifier = diskSpecifier.trim();
    }
}

