/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.plp;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.AbstractPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.plp.PLP;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PLPProvider
extends AbstractPlaylistProvider {
    private final Logger logger = LogManager.getLogger(PLPProvider.class);
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".plp"}, new String[]{"text/plain"}, new PlayerSupport[0], "Sansa Playlist File")};

    @Override
    public String getId() {
        return "plp";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        String line;
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-16LE";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, enc));
        PLP ret = new PLP();
        ret.setProvider(this);
        boolean magic1Found = false;
        boolean magic2Found = false;
        String disk = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            if (!magic1Found) {
                if (!"PLP PLAYLIST".equals(line)) {
                    throw new IllegalArgumentException("Not a PLP playlist format");
                }
                magic1Found = true;
                continue;
            }
            if (!magic2Found) {
                if (!"VERSION 1.20".equals(line)) {
                    this.logger.error("Malformed PLP playlist (no version information)");
                    ret = null;
                    break;
                }
                magic2Found = true;
                continue;
            }
            int idx = line.indexOf(44);
            if (idx <= 0) {
                this.logger.error("Malformed PLP playlist (playlist entry line format)");
                ret = null;
                break;
            }
            String tmpDisk = line.substring(0, idx).trim();
            if (disk == null) {
                disk = tmpDisk;
            } else if (!disk.equals(tmpDisk)) {
                this.logger.error("Malformed PLP playlist (inconsistent disk specifier)");
                ret = null;
                break;
            }
            ret.getFilenames().add(line.substring(idx + 1).trim());
        }
        if (ret != null && disk != null) {
            ret.setDiskSpecifier(disk);
        }
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws IOException {
        PLP ret = new PLP();
        ret.setProvider(this);
        this.addToPlaylist(ret.getFilenames(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<String> filenames, AbstractPlaylistComponent component) {
        block8: {
            block7: {
                if (!(component instanceof Sequence)) break block7;
                Sequence seq = (Sequence)component;
                if (seq.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("A PLP playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < seq.getRepeatCount()) {
                    seq.getComponents().forEach(c -> this.addToPlaylist(filenames, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block8;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with a PLP playlist");
            }
            if (!(component instanceof Media)) break block8;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A PLP playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("A PLP playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    filenames.add(media.getSource().toString());
                    ++iter;
                }
            }
        }
    }
}

