/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.pls;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.SpecificPlaylistProvider;
import io.github.borewit.lizzy.playlist.m3u.Resource;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class PLS
extends AbstractPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private final List<Resource> _resources = new ArrayList<Resource>();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, enc));
        writer.write("[Playlist]");
        writer.newLine();
        writer.write("NumberOfEntries=");
        writer.write(Integer.toString(this._resources.size()));
        writer.newLine();
        int i = 1;
        for (Resource resource : this._resources) {
            writer.write("File");
            writer.write(Integer.toString(i));
            writer.write("=");
            writer.write(resource.getLocation());
            writer.newLine();
            if (resource.getName() != null) {
                writer.write("Title");
                writer.write(Integer.toString(i));
                writer.write("=");
                writer.write(resource.getName());
                writer.newLine();
            }
            if (resource.getLength() >= 0L) {
                writer.write("Length");
                writer.write(Integer.toString(i));
                writer.write("=");
                writer.write(Long.toString(resource.getLength()));
                writer.newLine();
            }
            ++i;
        }
        writer.write("Version=2");
        writer.newLine();
        writer.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Resource resource : this._resources) {
            if (resource.getLocation() == null) continue;
            Media media = new Media();
            Content content = new Content(resource.getLocation());
            media.setSource(content);
            content.setDuration(resource.getLength() * 1000L);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    public List<Resource> getResources() {
        return this._resources;
    }
}

