/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.pls;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.AbstractPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.m3u.Resource;
import io.github.borewit.lizzy.playlist.pls.PLS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PLSProvider
extends AbstractPlaylistProvider {
    private final Logger logger = LogManager.getLogger(PLSProvider.class);
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".pls"}, new String[]{"audio/x-scpls"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINAMP, true, null), new PlayerSupport(PlayerSupport.Player.VLC_MEDIA_PLAYER, false, null), new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, true, null), new PlayerSupport(PlayerSupport.Player.FOOBAR2000, false, null), new PlayerSupport(PlayerSupport.Player.MPLAYER, true, null), new PlayerSupport(PlayerSupport.Player.QUICKTIME, true, null), new PlayerSupport(PlayerSupport.Player.ITUNES, true, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Winamp PLSv2 Playlist")};

    @Override
    public String getId() {
        return "pls";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        String line;
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, enc));
        PLS ret = new PLS();
        ret.setProvider(this);
        boolean magicFound = false;
        int numberOfEntries = -1;
        while ((line = reader.readLine()) != null) {
            Resource resource;
            int resourceIndex;
            if ((line = line.trim()).length() <= 0) continue;
            if (!magicFound) {
                if (!line.equalsIgnoreCase("[playlist]")) {
                    throw new IllegalArgumentException("Not a PLS playlist format");
                }
                magicFound = true;
                continue;
            }
            int idx = line.indexOf(61);
            if (idx <= 0) {
                this.logger.error("Malformed PLS playlist");
                ret = null;
                break;
            }
            String key = line.substring(0, idx).trim().toLowerCase();
            String value = line.substring(idx + 1).trim();
            if ("numberofentries".equals(key)) {
                int tmpValue;
                try {
                    tmpValue = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.logger.error(e.toString());
                    ret = null;
                    break;
                }
                if (tmpValue < 0) {
                    this.logger.warn("Invalid NumberOfEntries in PLS playlist: " + tmpValue);
                    ret = null;
                    break;
                }
                if (numberOfEntries >= 0 && numberOfEntries != tmpValue) {
                    this.logger.error("PLS playlist number of entries already specified with a different value");
                    ret = null;
                    break;
                }
                numberOfEntries = tmpValue;
                continue;
            }
            if (key.startsWith("file")) {
                key = key.substring(4);
                try {
                    resourceIndex = Integer.parseInt(key) - 1;
                }
                catch (NumberFormatException e) {
                    this.logger.error(e.toString());
                    ret = null;
                    break;
                }
                for (int i = ret.getResources().size(); i < resourceIndex + 1; ++i) {
                    ret.getResources().add(new Resource());
                }
                resource = ret.getResources().get(resourceIndex);
                resource.setLocation(value);
                continue;
            }
            if (key.startsWith("title")) {
                key = key.substring(5);
                try {
                    resourceIndex = Integer.parseInt(key) - 1;
                }
                catch (NumberFormatException e) {
                    this.logger.error(e.toString());
                    ret = null;
                    break;
                }
                for (int i = ret.getResources().size(); i < resourceIndex + 1; ++i) {
                    ret.getResources().add(new Resource());
                }
                resource = ret.getResources().get(resourceIndex);
                resource.setName(value);
                continue;
            }
            if (key.startsWith("length")) {
                key = key.substring(6);
                try {
                    resourceIndex = Integer.parseInt(key) - 1;
                }
                catch (NumberFormatException e) {
                    this.logger.error(e.toString());
                    ret = null;
                    break;
                }
                for (int i = ret.getResources().size(); i < resourceIndex + 1; ++i) {
                    ret.getResources().add(new Resource());
                }
                resource = ret.getResources().get(resourceIndex);
                try {
                    resource.setLength(Long.parseLong(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.logger.error(e.toString());
                    ret = null;
                    break;
                }
            }
            if ("version".equals(key)) {
                if ("2".equals(value)) continue;
                this.logger.error("Unknown PLS version " + value);
                ret = null;
                break;
            }
            this.logger.warn("Unknown PLS keyword " + key);
        }
        if (ret != null) {
            if (numberOfEntries < 0) {
                this.logger.warn("No number of entries in PLS playlist");
            } else {
                int extras = ret.getResources().size() - numberOfEntries;
                if (extras > 0) {
                    this.logger.warn("Ignoring " + extras + " extra resources according to the specified number of entries " + numberOfEntries);
                }
                for (int i = 0; i < extras; ++i) {
                    ret.getResources().remove(numberOfEntries);
                }
            }
        }
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws IOException {
        PLS ret = new PLS();
        ret.setProvider(this);
        this.addToPlaylist(ret.getResources(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<Resource> resources, AbstractPlaylistComponent component) {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence seq = (Sequence)component;
                if (seq.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("A PLS playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < seq.getRepeatCount()) {
                    seq.getComponents().forEach(c -> this.addToPlaylist(resources, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with a PLS playlist");
            }
            if (!(component instanceof Media)) break block9;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A PLS playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("A PLS playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    Resource resource = new Resource();
                    resource.setLocation(media.getSource().toString());
                    if (media.getSource().getDuration() >= 0L) {
                        resource.setLength((media.getSource().getDuration() + 999L) / 1000L);
                    }
                    resources.add(resource);
                    ++iter;
                }
            }
        }
    }
}

