/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.rmp;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.rmp.RmpProvider;
import io.github.borewit.lizzy.playlist.xml.rmp.RmpPackage;
import java.io.IOException;
import java.io.OutputStream;

public class RmpPlaylistAdapter
extends AbstractPlaylist {
    private RmpProvider provider;
    private final RmpPackage rmpPackage;

    public RmpPlaylistAdapter(RmpProvider provider, RmpPackage rmpPackage) {
        this.provider = provider;
        this.rmpPackage = rmpPackage;
    }

    @Override
    public JaxbPlaylistProvider getProvider() {
        return this.provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        this.provider.writeTo(this.rmpPackage, out, encoding);
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        String location = this.rmpPackage.getSERVER().getLOCATION();
        location = location.replace("%lid", this.rmpPackage.getTRACKLIST().getLISTID() == null ? "" : this.rmpPackage.getTRACKLIST().getLISTID());
        location = location.replace("%pid", this.rmpPackage.getTARGET() == null ? "" : this.rmpPackage.getTARGET());
        for (RmpPackage.TRACKLIST.TRACK track : this.rmpPackage.getTRACKLIST().getTRACK()) {
            String url = location.replace("%fid", track.getTRACKID() == null ? "" : track.getTRACKID());
            url = url.replace("%f", track.getFILENAME() == null ? "" : track.getFILENAME());
            if (this.rmpPackage.getSERVER().getNETNAME() != null) {
                StringBuilder sb = new StringBuilder("http://");
                sb.append(this.rmpPackage.getSERVER().getNETNAME());
                sb.append(url);
                url = sb.toString();
            }
            Media media = new Media();
            Content content = new Content(url);
            if (track.getSIZE() != null) {
                content.setLength(track.getSIZE());
            }
            if (track.getDURATION() != null) {
                content.setDuration(track.getDURATION().longValue() * 1000L);
            }
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }
}

