/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.rmp;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.rmp.RmpPlaylistAdapter;
import io.github.borewit.lizzy.playlist.xml.rmp.RmpPackage;
import io.github.borewit.lizzy.xml.Version;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class RmpProvider
extends JaxbPlaylistProvider<RmpPackage> {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".rmp"}, new String[]{"application/vnd.rn-rn_music_package"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.REALPLAYER, true, null)}, "Real Metadata Package (RMP)")};

    public RmpProvider() {
        super(RmpPackage.class);
    }

    @Override
    public String getId() {
        return "rmp";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        try {
            String rmpEncoding = encoding == null ? StandardCharsets.US_ASCII.toString() : encoding;
            JAXBElement rmp = this.unmarshal(inputStream, rmpEncoding);
            String rootElementName = rmp.getName().getLocalPart();
            return rootElementName != null && rootElementName.equalsIgnoreCase("PACKAGE") ? new RmpPlaylistAdapter(this, (RmpPackage)rmp.getValue()) : null;
        }
        catch (JAXBException | XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws IOException {
        RmpPackage rmpPackage = new RmpPackage();
        rmpPackage.setTITLE("Lizzy v" + Version.CURRENT + " RMP playlist");
        rmpPackage.setACTION("import,replace");
        rmpPackage.setTARGET(Integer.toString(System.identityHashCode(rmpPackage)));
        RmpPackage.TRACKLIST tracklist = new RmpPackage.TRACKLIST();
        tracklist.setLISTID(Integer.toString(System.identityHashCode(rmpPackage.getTRACKLIST())));
        rmpPackage.setTRACKLIST(tracklist);
        RmpPackage.PROVIDER provider = new RmpPackage.PROVIDER();
        provider.setAUTHOR("Christophe Delory");
        provider.setNAME("Lizzy v" + Version.CURRENT);
        provider.setURL("http://sourceforge.net/projects/lizzy/");
        provider.setCOPYRIGHT("Copyright (c) 2008-2009, Christophe Delory");
        provider.setCONTACT("cdelory@users.sourceforge.net");
        rmpPackage.setPROVIDER(provider);
        this.addToPlaylist(tracklist.getTRACK(), playlist.getRootSequence());
        return new RmpPlaylistAdapter(this, rmpPackage);
    }

    private void addToPlaylist(List<RmpPackage.TRACKLIST.TRACK> trackList, AbstractPlaylistComponent component) {
        block10: {
            block9: {
                if (!(component instanceof Sequence)) break block9;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("A RMP playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < sequence.getRepeatCount()) {
                    sequence.getComponents().forEach(c -> this.addToPlaylist(trackList, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block10;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A RMP playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block10;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A RMP playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("A RMP playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    RmpPackage.TRACKLIST.TRACK track = new RmpPackage.TRACKLIST.TRACK();
                    track.setTRACKID(Integer.toString(System.identityHashCode(track)));
                    track.setTITLE(media.getSource().toString());
                    track.setFILENAME(media.getSource().toString());
                    if (media.getSource().getLength() >= 0L) {
                        track.setSIZE(media.getSource().getLength());
                    }
                    if (media.getSource().getDuration() >= 0L) {
                        track.setDURATION((int)(media.getSource().getDuration() / 1000L));
                    }
                    trackList.add(track);
                    ++iter;
                }
            }
        }
    }
}

