/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.rss;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class RFC822 {
    private static final ThreadLocal<DateFormat> fullRfc822DatetimeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US));
    private static final ThreadLocal<DateFormat> fullRfc822DatetimeFormat2 = ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE, d MMM yyyy HH:mm Z", Locale.US));
    private static final ThreadLocal<DateFormat> compactRfc822DatetimeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("d MMM yyyy HH:mm:ss Z", Locale.US));
    private static final ThreadLocal<DateFormat> compactRfc822DatetimeFormat2 = ThreadLocal.withInitial(() -> new SimpleDateFormat("d MMM yyyy HH:mm Z", Locale.US));
    public static final ThreadLocal<DateFormat> iso8601DatetimeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US));

    public static String toString(Date date) {
        return fullRfc822DatetimeFormat.get().format(date);
    }

    public static Date valueOf(String dateString) {
        DateFormat[] formatsToTry;
        for (DateFormat dateFormat : formatsToTry = new DateFormat[]{fullRfc822DatetimeFormat.get(), fullRfc822DatetimeFormat2.get(), compactRfc822DatetimeFormat.get(), compactRfc822DatetimeFormat2.get()}) {
            try {
                Date ret = dateFormat.parse(dateString);
                if (ret == null) continue;
                return ret;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private RFC822() {
    }
}

