/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.rss;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.rss.RSSProvider;
import io.github.borewit.lizzy.playlist.xml.rss20.Enclosure;
import io.github.borewit.lizzy.playlist.xml.rss20.Item;
import io.github.borewit.lizzy.playlist.xml.rss20.ObjectFactory;
import io.github.borewit.lizzy.playlist.xml.rss20.Rss;
import io.github.borewit.lizzy.playlist.xml.rss20.media.Group;
import io.github.borewit.lizzy.playlist.xml.rss20.media.MediaContent;
import java.io.IOException;
import java.io.OutputStream;

public class RSSPlaylist
extends AbstractPlaylist {
    private transient RSSProvider provider = null;
    private final Rss rss;

    public RSSPlaylist(RSSProvider provider, Rss rss) {
        this.provider = provider;
        this.rss = rss;
    }

    @Override
    public RSSProvider getProvider() {
        return this.provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        this.provider.writeTo(new ObjectFactory().createRss(this.rss), out, encoding);
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Item item : this.rss.getChannel().getItem()) {
            Enclosure enclosure = item.getEnclosure();
            if (enclosure == null || enclosure.getUrl() == null) {
                block1: for (Group mediaGroup : item.getGroup()) {
                    boolean foundOne = false;
                    for (MediaContent mediaContent : mediaGroup.getContent()) {
                        if (!mediaContent.isIsDefault().booleanValue() || !this.addMediaContent(mediaContent, ret.getRootSequence())) continue;
                        foundOne = true;
                        break;
                    }
                    if (foundOne) continue;
                    for (MediaContent mediaContent : mediaGroup.getContent()) {
                        if (!this.addMediaContent(mediaContent, ret.getRootSequence())) continue;
                        foundOne = true;
                        continue block1;
                    }
                }
                for (MediaContent mediaContent : item.getContent()) {
                    this.addMediaContent(mediaContent, ret.getRootSequence());
                }
                continue;
            }
            Media media = new Media();
            Content content = new Content(enclosure.getUrl());
            content.setLength(enclosure.getLength());
            content.setType(enclosure.getType());
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    private boolean addMediaContent(MediaContent mediaContent, Sequence sequence) {
        boolean ret = false;
        if (mediaContent.getUrl() != null) {
            Media media = new Media();
            Content content = new Content(mediaContent.getUrl());
            content.setType(mediaContent.getType());
            if (mediaContent.getFileSize() != null) {
                content.setLength(mediaContent.getFileSize());
            }
            if (mediaContent.getDuration() != null) {
                content.setDuration(mediaContent.getDuration() * 1000L);
            }
            if (mediaContent.getWidth() != null) {
                content.setWidth(mediaContent.getWidth());
            }
            if (mediaContent.getHeight() != null) {
                content.setHeight(mediaContent.getHeight());
            }
            media.setSource(content);
            sequence.addComponent(media);
            ret = true;
        } else if (mediaContent.getPlayer() != null && mediaContent.getPlayer().getUrl() != null) {
            Media media = new Media();
            Content content = new Content(mediaContent.getPlayer().getUrl());
            content.setType(mediaContent.getType());
            if (mediaContent.getFileSize() != null) {
                content.setLength(mediaContent.getFileSize());
            }
            if (mediaContent.getDuration() != null) {
                content.setDuration(mediaContent.getDuration() * 1000L);
            }
            media.setSource(content);
            sequence.addComponent(media);
            ret = true;
        }
        return ret;
    }
}

