/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.rss;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.rss.RFC822;
import io.github.borewit.lizzy.playlist.rss.RSSPlaylist;
import io.github.borewit.lizzy.playlist.xml.rss20.Channel;
import io.github.borewit.lizzy.playlist.xml.rss20.Enclosure;
import io.github.borewit.lizzy.playlist.xml.rss20.Item;
import io.github.borewit.lizzy.playlist.xml.rss20.Rss;
import io.github.borewit.lizzy.playlist.xml.rss20.media.MediaContent;
import io.github.borewit.lizzy.xml.Version;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Date;
import javax.xml.stream.XMLStreamException;

public class RSSProvider
extends JaxbPlaylistProvider<Rss> {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".rss", ".xml"}, new String[]{"application/rss+xml"}, new PlayerSupport[0], "RSS Document")};
    private boolean _useRSSMedia = false;

    public RSSProvider() {
        super(Rss.class);
    }

    @Override
    public String getId() {
        return "rss";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        try {
            JAXBElement rssJAXBElement = this.unmarshal(inputStream, encoding);
            String rootElementName = rssJAXBElement.getName().getLocalPart();
            return rootElementName != null && rootElementName.equalsIgnoreCase("RSS") ? new RSSPlaylist(this, (Rss)rssJAXBElement.getValue()) : null;
        }
        catch (JAXBException | XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws IOException {
        Rss rss = new Rss();
        Channel channel = new Channel();
        rss.setChannel(channel);
        channel.setTitle("Lizzy v" + Version.CURRENT + " RSS playlist");
        channel.setDescription("A list of media contents");
        channel.setLink("http://sourceforge.net/projects/lizzy/");
        channel.setLanguage("en");
        channel.setCopyright("Copyright (c) 2008-2009, Christophe Delory");
        String rfc822date = RFC822.toString(new Date());
        channel.setPubDate(rfc822date);
        channel.setLastBuildDate(rfc822date);
        channel.setGenerator("Lizzy v" + Version.CURRENT);
        this.addToPlaylist(channel, playlist.getRootSequence());
        return new RSSPlaylist(this, rss);
    }

    private void addToPlaylist(Channel channel, AbstractPlaylistComponent component) {
        block18: {
            block17: {
                if (!(component instanceof Sequence)) break block17;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("A RSS playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < sequence.getRepeatCount()) {
                    sequence.getComponents().forEach(c -> this.addToPlaylist(channel, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block18;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A RSS playlist doesn't support concurrent media");
            }
            if (!(component instanceof Media)) break block18;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A RSS playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("A RSS playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    String url;
                    Item item = new Item();
                    if (this._useRSSMedia) {
                        MediaContent content = new MediaContent();
                        try {
                            content.setUrl(media.getSource().getURL().toString());
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                        url = content.getUrl();
                        content.setFileSize(media.getSource().getLength());
                        content.setType(media.getSource().getType());
                        content.setIsDefault(true);
                        if (media.getSource().getDuration() >= 0L) {
                            content.setDuration((media.getSource().getDuration() + 999L) / 1000L);
                        }
                        if (media.getSource().getWidth() >= 0) {
                            content.setWidth(media.getSource().getWidth());
                        }
                        if (media.getSource().getHeight() >= 0) {
                            content.setHeight(media.getSource().getHeight());
                        }
                        item.getContent().add(content);
                    } else {
                        Enclosure enclosure = new Enclosure();
                        try {
                            enclosure.setUrl(media.getSource().getURI().toString());
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                        url = enclosure.getUrl();
                        enclosure.setLength(media.getSource().getLength());
                        if (media.getSource().getType() != null) {
                            enclosure.setType(media.getSource().getType());
                        }
                        item.setEnclosure(enclosure);
                    }
                    item.setTitle(url);
                    channel.getItem().add(item);
                    ++iter;
                }
            }
        }
    }

    public void setUseRSSMedia(boolean useRSSMedia) {
        this._useRSSMedia = useRSSMedia;
    }
}

