/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.smil20;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.AbstractTimeContainer;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.smil20.SmilProvider;
import io.github.borewit.lizzy.playlist.xml.smil20.Smil;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilContainerBody;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilMutuallyExclusive;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilParallel;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilReference;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilSequence;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilTimeContainer;
import java.io.IOException;
import java.io.OutputStream;

public class SmilAdapter
extends AbstractPlaylist {
    private final SmilProvider provider;
    private final Smil smil;

    public SmilAdapter(SmilProvider provider, Smil smil) {
        this.provider = provider;
        this.smil = smil;
    }

    @Override
    public SmilProvider getProvider() {
        return this.provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        this.provider.writeTo(this.smil, out, encoding);
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        SmilContainerBody body = this.smil.getBody();
        if (body != null) {
            body.getSeqOrParOrExl().forEach(timingElement -> this.addToContainer((SmilTimeContainer)timingElement, ret.getRootSequence()));
            ret.normalize();
        }
        return ret;
    }

    private void addToContainer(SmilTimeContainer timeContainer, AbstractTimeContainer currentContainer) {
        AbstractTimeContainer abstractTimeContainer;
        timeContainer.getAudioOrImgOrRef().stream().map(SmilReference::getSrc).map(Content::new).map(Media::new).forEach(currentContainer::addComponent);
        if (timeContainer instanceof SmilSequence) {
            abstractTimeContainer = new Sequence();
        } else if (timeContainer instanceof SmilParallel) {
            abstractTimeContainer = new Parallel();
        } else {
            if (timeContainer instanceof SmilMutuallyExclusive) {
                return;
            }
            return;
        }
        abstractTimeContainer.setRepeatCount(timeContainer.getRepeatCount());
        currentContainer.addComponent(abstractTimeContainer);
        timeContainer.getSeqOrParOrExl().forEach(timingElement -> this.addToContainer((SmilTimeContainer)timingElement, currentContainer));
    }
}

