/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.smil20;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.AbstractTimeContainer;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.smil20.SmilAdapter;
import io.github.borewit.lizzy.playlist.xml.smil20.Smil;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilContainerBody;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilParallel;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilReference;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilSequence;
import io.github.borewit.lizzy.playlist.xml.smil20.SmilTimeContainer;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class SmilProvider
extends JaxbPlaylistProvider<Smil> {
    public static final String smilNamespace = "http://www.w3.org/2001/SMIL20/Language";
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".smil", ".smi"}, new String[]{"application/smil+xml", "application/smil"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, false, null), new PlayerSupport(PlayerSupport.Player.QUICKTIME, true, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Synchronized Multimedia Integration Language (SMIL)")};

    public SmilProvider() {
        super(Smil.class);
    }

    @Override
    public String getId() {
        return "smil";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        try {
            JAXBElement smil = this.unmarshal(inputStream, encoding);
            String rootElementName = smil.getName().getLocalPart();
            return rootElementName != null && rootElementName.equalsIgnoreCase("smil") ? new SmilAdapter(this, (Smil)smil.getValue()) : null;
        }
        catch (JAXBException | XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) {
        Smil smil = new Smil();
        SmilContainerBody body = new SmilContainerBody();
        smil.setBody(body);
        SmilSequence smilSequence = new SmilSequence();
        body.getSeqOrParOrExl().add(smilSequence);
        this.addToPlaylist(smilSequence, playlist.getRootSequence());
        return new SmilAdapter(this, smil);
    }

    private void addToPlaylist(SmilTimeContainer timingElement, AbstractPlaylistComponent component) {
        if (component instanceof AbstractTimeContainer) {
            SmilTimeContainer smilTimeContainer;
            AbstractTimeContainer timeContainer = (AbstractTimeContainer)component;
            if (component instanceof Sequence) {
                smilTimeContainer = new SmilSequence();
            } else if (component instanceof Parallel) {
                smilTimeContainer = new SmilParallel();
            } else {
                throw new RuntimeException("Unexpected AbstractTimeContainer instance");
            }
            smilTimeContainer.setRepeatCount(Float.valueOf(timeContainer.getRepeatCount()));
            timingElement.getSeqOrParOrExl().add(smilTimeContainer);
            timeContainer.getComponents().forEach(c -> this.addToPlaylist(smilTimeContainer, (AbstractPlaylistComponent)c));
        } else if (component instanceof Media) {
            Media media = (Media)component;
            SmilReference ref = new SmilReference();
            if (media.getSource() != null) {
                ref.setSrc(media.getSource().toString());
                ref.setType(media.getSource().getType());
            }
            ref.setDur(media.getDuration());
            ref.setRepeatCount(Float.valueOf(media.getRepeatCount()));
            timingElement.getAudioOrImgOrRef().add(ref);
        } else {
            throw new RuntimeException("Unexpected component instance type");
        }
    }

    @Override
    protected XMLStreamReader getXmlStreamReader(InputStream in, String encoding) throws XMLStreamException {
        return new NormalizeNamespace(super.getXmlStreamReader(in, encoding));
    }

    private static class NormalizeNamespace
    extends StreamReaderDelegate {
        NormalizeNamespace(XMLStreamReader xsr) {
            super(xsr);
        }

        @Override
        public String getNamespaceURI() {
            String nsUri = super.getNamespaceURI();
            return nsUri == null ? SmilProvider.smilNamespace : nsUri;
        }
    }
}

