/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.smil20.xml;

import io.github.borewit.lizzy.lang.StringUtils;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;

public class DurationValueXmlAdapter
extends XmlAdapter<String, Long> {
    private static String INDEFINITE = "indefinite";

    public String marshal(Long _duration) {
        String ret = null;
        if (_duration != null) {
            if (_duration.equals(Long.MAX_VALUE)) {
                ret = INDEFINITE;
            } else {
                String suffix;
                StringBuilder sb = new StringBuilder();
                long millis = _duration;
                long i = millis / 3600000L;
                if (i > 0L) {
                    sb.append(StringUtils.toString(i, 2));
                    sb.append(':');
                    millis -= i * 60L * 60L * 1000L;
                }
                if ((i = millis / 60000L) > 0L) {
                    sb.append(StringUtils.toString(i, 2));
                    sb.append(':');
                    millis -= i * 60L * 1000L;
                }
                i = millis / 1000L;
                if (sb.length() <= 0) {
                    sb.append(i);
                    suffix = "s";
                } else {
                    sb.append(StringUtils.toString(i, 2));
                    suffix = "";
                }
                if ((millis -= i * 1000L) > 0L) {
                    sb.append('.');
                    sb.append(StringUtils.toString(millis, 3));
                }
                sb.append(suffix);
                ret = sb.toString();
            }
        }
        return ret;
    }

    public Long unmarshal(String xmlValue) {
        String str = xmlValue.trim();
        if (str.equalsIgnoreCase("media")) {
            return null;
        }
        if (INDEFINITE.equalsIgnoreCase(str)) {
            return Long.MAX_VALUE;
        }
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long millis = 0L;
        String[] array = str.split(":");
        switch (array.length) {
            case 3: {
                hours = Long.parseLong(array[0]);
                if (hours < 0L) {
                    throw new IllegalArgumentException("Negative hours");
                }
                minutes = Long.parseLong(array[1]);
                if (minutes < 0L || minutes > 59L) {
                    throw new IllegalArgumentException("Invalid minutes");
                }
                String[] subArray = array[2].split("\\.");
                if (subArray.length > 2) {
                    throw new IllegalArgumentException("Invalid duration format " + str);
                }
                seconds = Long.parseLong(subArray[0]);
                if (seconds < 0L || seconds > 59L) {
                    throw new IllegalArgumentException("Invalid seconds");
                }
                if (subArray.length <= 1) break;
                StringBuilder sb = new StringBuilder(subArray[1]);
                switch (sb.length()) {
                    case 1: {
                        sb.append("00");
                        break;
                    }
                    case 2: {
                        sb.append('0');
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        sb.delete(3, sb.length());
                    }
                }
                millis = Long.parseLong(sb.toString());
                if (millis >= 0L) break;
                throw new IllegalArgumentException("Negative milliseconds");
            }
            case 2: {
                minutes = Long.parseLong(array[0]);
                if (minutes < 0L || minutes > 59L) {
                    throw new IllegalArgumentException("Invalid minutes");
                }
                String[] subArray = array[1].split("\\.");
                if (subArray.length > 2) {
                    throw new IllegalArgumentException("Invalid duration format " + str);
                }
                seconds = Long.parseLong(subArray[0]);
                if (seconds < 0L || seconds > 59L) {
                    throw new IllegalArgumentException("Invalid seconds");
                }
                if (subArray.length <= 1) break;
                StringBuilder sb = new StringBuilder(subArray[1]);
                switch (sb.length()) {
                    case 1: {
                        sb.append("00");
                        break;
                    }
                    case 2: {
                        sb.append('0');
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        sb.delete(3, sb.length());
                    }
                }
                millis = Long.parseLong(sb.toString());
                if (millis >= 0L) break;
                throw new IllegalArgumentException("Negative milliseconds");
            }
            case 1: {
                String input = array[0].toLowerCase();
                float multiplier = 1000.0f;
                if (input.endsWith("h")) {
                    input = input.substring(0, input.length() - 1);
                    multiplier = 3600000.0f;
                } else if (input.endsWith("min")) {
                    input = input.substring(0, input.length() - 3);
                    multiplier = 60000.0f;
                } else if (input.endsWith("ms")) {
                    input = input.substring(0, input.length() - 2);
                    multiplier = 1.0f;
                } else if (input.endsWith("s")) {
                    input = input.substring(0, input.length() - 1);
                }
                float f = Float.parseFloat(input);
                millis = (long)(f *= multiplier);
                if (millis >= 0L) break;
                throw new IllegalArgumentException("Negative time");
            }
            default: {
                throw new IllegalArgumentException("Invalid SMIL duration format " + str);
            }
        }
        return hours * 60L * 60L * 1000L + minutes * 60L * 1000L + seconds * 1000L + millis;
    }
}

