/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.xspf;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.xml.xspf.ObjectFactory;
import io.github.borewit.lizzy.playlist.xml.xspf.XspfPlaylist;
import io.github.borewit.lizzy.playlist.xml.xspf.XspfTrack;
import java.io.IOException;
import java.io.OutputStream;

public class XspfPlaylistAdapter
extends AbstractPlaylist {
    private final JaxbPlaylistProvider provider;
    private final XspfPlaylist xspfPlaylist;

    public XspfPlaylistAdapter(JaxbPlaylistProvider provider, XspfPlaylist xspfPlaylist) {
        this.provider = provider;
        this.xspfPlaylist = xspfPlaylist;
    }

    @Override
    public JaxbPlaylistProvider getProvider() {
        return this.provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        this.provider.writeTo(new ObjectFactory().createPlaylist(this.xspfPlaylist), out, encoding);
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        if (this.xspfPlaylist.getTrackList() != null) {
            for (XspfTrack track : this.xspfPlaylist.getTrackList().getTrack()) {
                for (String location : track.getLocation()) {
                    Media media = new Media();
                    Content content = new Content(location);
                    media.setSource(content);
                    if (track.getDuration() != null) {
                        content.setDuration(track.getDuration().longValue());
                    }
                    ret.getRootSequence().addComponent(media);
                }
            }
            ret.normalize();
        }
        return ret;
    }
}

