/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.xspf;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.xml.xspf.XspfPlaylist;
import io.github.borewit.lizzy.playlist.xml.xspf.XspfTrack;
import io.github.borewit.lizzy.playlist.xml.xspf.XspfTrackList;
import io.github.borewit.lizzy.playlist.xspf.XspfPlaylistAdapter;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class XspfProvider
extends JaxbPlaylistProvider<XspfPlaylist> {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".xspf"}, new String[]{"application/xspf+xml"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.VLC_MEDIA_PLAYER, true, null)}, "XML Shareable Playlist Format (XSPF)")};

    public XspfProvider() {
        super(XspfPlaylist.class);
    }

    @Override
    public String getId() {
        return "xspf";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        try {
            JAXBElement xspfPlaylist = this.unmarshal(inputStream, encoding);
            String rootElementName = xspfPlaylist.getName().getLocalPart();
            return rootElementName != null && rootElementName.equals("playlist") ? new XspfPlaylistAdapter(this, (XspfPlaylist)xspfPlaylist.getValue()) : null;
        }
        catch (JAXBException | XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws IOException {
        XspfTrackList xspfTrackList = new XspfTrackList();
        this.addToPlaylist(xspfTrackList.getTrack(), playlist.getRootSequence());
        XspfPlaylist xspfPlaylist = new XspfPlaylist();
        xspfPlaylist.setTrackList(xspfTrackList);
        return new XspfPlaylistAdapter(this, xspfPlaylist);
    }

    private void addToPlaylist(List<XspfTrack> xspfTrackList, AbstractPlaylistComponent component) {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("An XSPF playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < sequence.getRepeatCount()) {
                    sequence.getComponents().forEach(c -> this.addToPlaylist(xspfTrackList, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("An XSPF playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block9;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("An XSPF playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("An XSPF playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    XspfTrack track = new XspfTrack();
                    track.getLocation().add(media.getSource().toString());
                    if (media.getSource().getDuration() > 0L) {
                        track.setDuration(BigInteger.valueOf(media.getSource().getDuration()));
                    }
                    xspfTrackList.add(track);
                    ++iter;
                }
            }
        }
    }
}

