/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.xml;

import java.io.Serializable;

public class Version
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    public static Version CURRENT = new Version();
    private int _version;
    private int _revision;
    private int _step;

    public static Version valueOf(String name) {
        int k = name.indexOf(46);
        if (k < 0) {
            throw new IllegalArgumentException("The format of a version string is <version.revision.step>");
        }
        if (k == 0) {
            throw new IllegalArgumentException("No version part in version string '" + name + '\'');
        }
        if (k + 1 >= name.length()) {
            throw new IllegalArgumentException("No revision/step part in version string '" + name + '\'');
        }
        int l = name.indexOf(46, k + 1);
        if (l < 0) {
            throw new IllegalArgumentException("The format of a version string is <version.revision.step>");
        }
        if (l == k + 1) {
            throw new IllegalArgumentException("No revision part in version string '" + name + '\'');
        }
        if (l + 1 >= name.length()) {
            throw new IllegalArgumentException("No step part in version string '" + name + '\'');
        }
        String versionString = name.substring(0, k);
        String revisionString = name.substring(k + 1, l);
        String stepString = name.substring(l + 1);
        int version = Integer.parseInt(versionString);
        int revision = Integer.parseInt(revisionString);
        int step = Integer.parseInt(stepString);
        return new Version(version, revision, step);
    }

    private Version() {
        this._version = 0;
        this._revision = 0;
        this._step = 0;
    }

    public Version(int version, int revision, int step) {
        this.setVersion(version);
        this.setRevision(revision);
        this.setStep(step);
    }

    private void setVersion(int version) {
        if (version < 0) {
            throw new IndexOutOfBoundsException("Version number is negative");
        }
        this._version = version;
    }

    public int getVersion() {
        return this._version;
    }

    private void setRevision(int revision) {
        if (revision < 0) {
            throw new IndexOutOfBoundsException("Revision number is negative");
        }
        this._revision = revision;
    }

    public int getRevision() {
        return this._revision;
    }

    private void setStep(int step) {
        if (step < 0) {
            throw new IndexOutOfBoundsException("Step number is negative");
        }
        this._step = step;
    }

    public int getStep() {
        return this._step;
    }

    public int compareTo(Object o) {
        return this.hashCode() - ((Version)o).hashCode();
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj != null && obj instanceof Version) {
            ret = this.hashCode() == obj.hashCode();
        }
        return ret;
    }

    public int hashCode() {
        return (this._version & 0x3FF) << 20 | (this._revision & 0x3FF) << 10 | this._step & 0x3FF;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._version);
        sb.append('.');
        sb.append(this._revision);
        sb.append('.');
        sb.append(this._step);
        return sb.toString();
    }
}

