/* 
 * Copyright 2014 JRimum Project
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Created at: 27/01/2014 - 02:21:50
 *
 * ================================================================================
 *
 * Direitos autorais 2014 JRimum Project
 *
 * Licenciado sob a Licença Apache, Versão 2.0 ("LICENÇA"); você não pode 
 * usar esse arquivo exceto em conformidade com a esta LICENÇA. Você pode obter uma 
 * cópia desta LICENÇA em http://www.apache.org/licenses/LICENSE-2.0 A menos que 
 * haja exigência legal ou acordo por escrito, a distribuição de software sob esta 
 * LICENÇA se dará “COMO ESTÁ”, SEM GARANTIAS OU CONDIÇÕES DE QUALQUER TIPO, sejam 
 * expressas ou tácitas. Veja a LICENÇA para a redação específica a reger permissões 
 * e limitações sob esta LICENÇA.
 * 
 * Criado em: 27/01/2014 - 02:21:50 
 * 
 */
package org.jrimum.bopepo.view;

import static org.apache.commons.lang3.StringUtils.isBlank;
import static org.apache.commons.lang3.StringUtils.leftPad;

import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.view.ResourceBundle;
import org.jrimum.domkee.banco.Agencia;
import org.jrimum.domkee.banco.Carteira;
import org.jrimum.domkee.banco.NumeroDaConta;

/**
 * @author <a href="http://gilmatryx.googlepages.com/">Gilmar P.S.L.</a>
 */
public class BoletoInfoViewBradesco extends AbstractBoletoInfoCampoView {

    public BoletoInfoViewBradesco(ResourceBundle resourceBundle, Boleto boleto) {
        super(resourceBundle, boleto);
    }

    @Override
    public String getTextoFcLocalPagamento() {
        String textoFcLocalPagamento = super.getTextoFcLocalPagamento();
        return isBlank(textoFcLocalPagamento) ? "Pagável Preferencialmente na rede Bradesco ou no Bradesco expresso" : textoFcLocalPagamento;
    }

    @Override
    public String getTextoFcAgenciaCodigoCedente() {
        Agencia agencia = getBoleto().getTitulo().getContaBancaria().getAgencia();
        NumeroDaConta numeroDaConta = getBoleto().getTitulo().getContaBancaria().getNumeroDaConta();

        return leftPad(agencia.getCodigo().toString(), 4, "0")
                + "-" + agencia.getDigitoVerificador()
                + " / "
                + leftPad(numeroDaConta.getCodigoDaConta().toString(), 7, "0")
                + "-" + numeroDaConta.getDigitoDaConta();
    }

    @Override
    public String getTextoRsAgenciaCodigoCedente() {
        return getTextoFcAgenciaCodigoCedente();
    }

    @Override
    public String getTextoFcNossoNumero() {
        Carteira carteira = getBoleto().getTitulo().getContaBancaria().getCarteira();
        return leftPad(carteira.getCodigo().toString(), 2, "0")
                + "/"
                + getBoleto().getTitulo().getNossoNumero()
                + "-" + getBoleto().getTitulo().getDigitoDoNossoNumero();
    }

    @Override
    public String getTextoRsNossoNumero() {
        return getTextoFcNossoNumero();
    }
}
