/*
 * Decompiled with CFR 0.152.
 */
package com.github.braully.boleto;

import com.github.braully.boleto.RegistroArquivo;
import com.github.braully.boleto.TagLayout;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ArquivoFacade {
    public static Logger logger = Logger.getLogger(ArquivoFacade.class);
    TagLayout template;
    List<RegistroArquivo> registros = new ArrayList<RegistroArquivo>();
    List<String> linhas = new ArrayList<String>();

    public ArquivoFacade() {
    }

    public ArquivoFacade(TagLayout template) {
        this.template = template;
    }

    public List<String> renderLinhas() {
        ArrayList<String> linhas = new ArrayList<String>();
        for (RegistroArquivo r : this.registros) {
            String render = r.render();
            linhas.add(render);
        }
        return linhas;
    }

    public void parse(List<String> linhas) {
        this.registros.clear();
        this.linhas.clear();
        if (linhas != null) {
            this.linhas.addAll(linhas);
        }
        ArrayList<RegistroArquivo> registrosLayout = new ArrayList<RegistroArquivo>();
        if (this.template != null && this.template.filhos != null) {
            for (TagLayout tag : this.template.filhos) {
                registrosLayout.add(new RegistroArquivo(tag));
            }
        }
        for (String linha : linhas) {
            if (linha == null) continue;
            linha = linha.replace("\r", "").replace("\n", "");
            RegistroArquivo regLido = null;
            for (RegistroArquivo reg : registrosLayout) {
                RegistroArquivo clone = reg.clone();
                if (!clone.checkIds(linha)) continue;
                regLido = clone;
                try {
                    regLido.read(linha);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Fail on read line: " + linha + " for reg: " + reg.toStringLayoutFields(), e);
                }
            }
            if (regLido != null) {
                this.registros.add(regLido);
                continue;
            }
            throw new IllegalStateException("Linha n\u00e3o reconhecida no layout linha=" + linha + " layout=" + this.template);
        }
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        List<String> linhas = this.renderLinhas();
        for (String linha : linhas) {
            sb.append(linha);
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public ArquivoFacade add(RegistroArquivo reg) {
        this.registros.add(reg);
        return this;
    }

    public RegistroArquivo get(String str) {
        return this.get(this.template.get(str));
    }

    public RegistroArquivo get(TagLayout tiporegistro) {
        for (RegistroArquivo reg : this.registros) {
            if (reg.layoutRegistro != tiporegistro) continue;
            return reg;
        }
        return null;
    }

    public List<RegistroArquivo> gets(String str) {
        return this.gets(this.template.get(str));
    }

    public List<RegistroArquivo> gets(TagLayout tiporegistro) {
        ArrayList<RegistroArquivo> regs = new ArrayList<RegistroArquivo>();
        for (RegistroArquivo reg : this.registros) {
            if (!reg.getName().equalsIgnoreCase(tiporegistro.nome)) continue;
            regs.add(reg);
        }
        return regs;
    }
}

