/*
 * Decompiled with CFR 0.152.
 */
package com.github.braully.boleto;

import com.github.braully.boleto.TagLayout;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.jrimum.texgit.FixedField;
import org.jrimum.texgit.IFiller;
import org.jrimum.texgit.Record;
import org.jrimum.utilix.Objects;

public class RegistroArquivo
extends Record {
    protected TagLayout layoutRegistro;
    protected List<FixedField> extraIds;

    public RegistroArquivo() {
    }

    public RegistroArquivo(TagLayout layoutRegistro) {
        this.setName(layoutRegistro.nome);
        this.layoutRegistro = layoutRegistro;
        layoutRegistro.filhos.stream().forEach(l -> this.add((TagLayout)l));
    }

    public void addExtraId(FixedField fixedField) {
        if (this.extraIds == null) {
            this.extraIds = new ArrayList<FixedField>();
        }
        this.extraIds.add(fixedField);
    }

    public String render() {
        return this.write();
    }

    public RegistroArquivo sequencialRegistro(Integer seq) {
        this.setValue(TagLayout.TagCreator.fsequencialRegistro().nome, seq);
        return this;
    }

    public Integer sequencialRegistro() {
        return this.getValueAsInteger();
    }

    public RegistroArquivo banco(String codigo, String nome) {
        this.setValue(TagLayout.TagCreator.fbancoCodigo().nome, codigo).setValue(TagLayout.TagCreator.fbancoNome().nome, nome.toUpperCase());
        return this;
    }

    public Integer sequencialArquivo() {
        return this.getValueAsInteger(TagLayout.TagCreator.fsequencialArquivo().nome);
    }

    public String bancoCodigo() {
        return (String)this.getValue(TagLayout.TagCreator.fbancoCodigo().nome);
    }

    public RegistroArquivo cedente(String nome, String cnpj) {
        this.setValue(TagLayout.TagCreator.fcedenteNome().nome, nome).setValue(TagLayout.TagCreator.fcedenteCnpj().nome, cnpj);
        return this;
    }

    public String cedenteCnpj() {
        return (String)this.getValue(TagLayout.TagCreator.fcedenteCnpj().nome);
    }

    public RegistroArquivo convenio(String convenio, String agencia, String conta, String dac) {
        this.convenio(convenio).agencia(agencia).conta(conta).dac(dac);
        return this;
    }

    public RegistroArquivo convenio(String convenio, String carteira, String agencia, String conta, String dac) {
        this.convenio(convenio).carteira(carteira).agencia(agencia).conta(conta).dac(dac);
        return this;
    }

    public RegistroArquivo endereco(String endereco) {
        return this.setValue(endereco);
    }

    public RegistroArquivo endereco(String logradouro, String numero, String complemento, String nomeCidade, String cep, String uf) {
        this.setValue(logradouro).setValue("numero", numero).setValue("complemento", complemento == null ? "" : complemento).setValue("cidade", nomeCidade).setValue("cep", cep).setValue("uf", uf);
        return this;
    }

    public RegistroArquivo convenio(String convenio) {
        return this.setValue(convenio);
    }

    public RegistroArquivo carteira(String carteira) {
        return this.setValue(carteira);
    }

    public RegistroArquivo variacao(String variacao) {
        return this.setValue(variacao);
    }

    public RegistroArquivo modalidade(String modalidade) {
        return this.setValue(modalidade);
    }

    public String convenio() {
        return (String)this.getValue(TagLayout.TagCreator.fconvenio().nome);
    }

    public RegistroArquivo agencia(Object agencia) {
        if (agencia != null && ((String)agencia).length() == 4) {
            agencia = agencia + "-0";
        }
        return this.setValue(agencia);
    }

    public String agencia() {
        return (String)this.getValue(TagLayout.TagCreator.fagencia().nome);
    }

    public RegistroArquivo conta(String conta) {
        return this.setValue(conta);
    }

    public String conta() {
        return (String)this.getValue(TagLayout.TagCreator.fconta().nome);
    }

    public RegistroArquivo dac(String dac) {
        return this.setValue(dac);
    }

    public RegistroArquivo setVal(String nomeAtributo, Object valor) {
        this.setValue(nomeAtributo, valor);
        return this;
    }

    protected String getValue() {
        String nomeMetodoAnterior = Thread.currentThread().getStackTrace()[2].getMethodName();
        Object value = this.getValue(nomeMetodoAnterior);
        String ret = null;
        if (value != null) {
            ret = value.toString();
        }
        return ret;
    }

    protected String removeLeftZeros(String number) {
        if (number == null) {
            return null;
        }
        return number.replaceFirst("^0+(?!$)", "");
    }

    protected String trimNumberValue(String str) {
        if (str != null) {
            str = str.replaceAll("\\D", "");
            str = this.removeLeftZeros(str);
        }
        return str;
    }

    public Integer getValueAsInteger() {
        String nomeMetodoAnterior = Thread.currentThread().getStackTrace()[2].getMethodName();
        return this.getValueAsInteger(nomeMetodoAnterior);
    }

    public Integer getValueAsInteger(String nomefield) {
        Object value = this.getValue(nomefield);
        Integer ret = null;
        if (value != null) {
            ret = value instanceof Integer ? (Integer)value : Integer.valueOf(Integer.parseInt(this.trimNumberValue(value.toString())));
        }
        return ret;
    }

    public Number getValueAsNumber() {
        String nomeMetodoAnterior = Thread.currentThread().getStackTrace()[2].getMethodName();
        Object value = this.getValue(nomeMetodoAnterior);
        Number ret = null;
        if (value != null) {
            ret = value instanceof Number ? (Number)((Number)value) : (Number)Long.parseLong(this.trimNumberValue(value.toString()));
        }
        return ret;
    }

    protected RegistroArquivo setValue(Object valor) {
        String nomeMetodoAnterior = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.setValue(nomeMetodoAnterior, valor);
        return this;
    }

    private void add(TagLayout l) {
        IFiller filler;
        Integer len;
        String value;
        FixedField<String> fixedField = new FixedField<String>();
        if (this.isValid(l.nome)) {
            fixedField.setName(l.nome);
        }
        if (this.isValid(value = l.getAtr("value"))) {
            fixedField.setValue(value);
        }
        if (Objects.isNotNull(len = l.getInt("length"))) {
            fixedField.setFixedLength(len);
        } else if ("field".equals(l.nome)) {
            throw new IllegalArgumentException("Field " + l + " sem comprimento (lenght) ");
        }
        Format format = (Format)l.getObj("format");
        if (Objects.isNotNull(format)) {
            fixedField.setFormatter(format);
        }
        if (Objects.isNotNull(filler = (IFiller)l.getObj("filler"))) {
            fixedField.setFiller(filler);
            fixedField.setBlankAccepted(true);
            fixedField.setValue("");
        }
        if (Objects.isNotNull(filler = (IFiller)l.getObj("padding"))) {
            fixedField.setFiller(filler);
        }
        if (l.isAttr("truncate")) {
            fixedField.setTruncate(true);
        }
        if (l.isAttr("apenasDigitos")) {
            fixedField.setApenasDigitos(true);
        }
        if (l.isAttr("id")) {
            if (this.getIdType() == null) {
                this.setIdType(fixedField);
            } else {
                this.addExtraId(fixedField);
            }
        }
        super.add(fixedField);
        super.incLength(len);
        super.incSize();
    }

    public String toString() {
        return this.toStringValorFields();
    }

    public String toStringValorFields() {
        StringBuilder sb = new StringBuilder("Registro{value=");
        if (this.layoutRegistro != null) {
            sb.append(this.layoutRegistro.nome);
        }
        sb.append(",\n fields=[");
        if (this.fields != null) {
            sb.append("\n");
            for (FixedField ff : this.fields) {
                Object value = ff.getValue();
                String name = ff.getName();
                if (name == null || name.trim().isEmpty() || value == null || value.toString().trim().isEmpty()) continue;
                sb.append("\t");
                sb.append(name);
                sb.append("=");
                sb.append(value);
                sb.append("\n");
            }
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    public String toStringLayoutFields() {
        StringBuilder sb = new StringBuilder("Registro{value=");
        if (this.layoutRegistro != null) {
            sb.append(this.layoutRegistro.nome);
        }
        sb.append(",\nlen=").append(this.getFixedLength());
        sb.append(",\n fields=[");
        if (this.fields != null) {
            sb.append("\n");
            for (FixedField ff : this.fields) {
                String name = ff.getName();
                if (name == null || name.trim().isEmpty()) continue;
                sb.append("\t");
                sb.append(name);
                sb.append(" [len: ");
                sb.append(ff.getFixedLength());
                sb.append("]\n");
            }
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    public String getDescricaoLayout() {
        StringBuilder sb = new StringBuilder("Registro{layout=");
        if (this.layoutRegistro != null) {
            sb.append(this.layoutRegistro.nome);
        }
        sb.append(",\n fields=[");
        if (this.fields != null) {
            sb.append("\n");
            for (FixedField ff : this.fields) {
                sb.append("\t");
                sb.append(ff.getName());
                sb.append("=");
                sb.append(ff.getLength());
                sb.append("\n");
            }
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public RegistroArquivo clone() {
        RegistroArquivo clone = new RegistroArquivo(this.layoutRegistro);
        return clone;
    }

    private boolean isValid(String nome) {
        return nome != null;
    }

    public boolean checkIds(String linha) {
        boolean ret;
        FixedField<String> id = null;
        FixedField<String> idType = this.getIdType();
        try {
            id = this.getId(linha);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = ret = idType != null && idType.equalsValue(id);
        if (ret && this.extraIds != null) {
            for (FixedField ff : this.extraIds) {
                FixedField<String> lval = this.get(ff, linha);
                ret = ret && ff.equalsValue(lval);
            }
        }
        return ret;
    }

    public String movimentoCodigo() {
        return (String)this.getValue(TagLayout.TagCreator.fmovimentoCodigo().nome);
    }
}

