/*
 * Decompiled with CFR 0.152.
 */
package com.github.braully.boleto;

import com.github.braully.boleto.CNAB;
import com.github.braully.boleto.CNABServico;
import java.io.Serializable;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.SerializationUtils;
import org.jrimum.domkee.banco.IBanco;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.IFiller;

public class TagLayout
implements Serializable {
    String nome;
    Object value;
    List<TagLayout> filhos;
    Map<String, Object> atributos;

    boolean isAttr(String id) {
        return this.is(this.atributos.get(id));
    }

    private boolean is(Object get) {
        boolean ret = false;
        if (get != null) {
            try {
                ret = get instanceof Boolean ? (Boolean)get : Boolean.parseBoolean(get.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public TagLayout nome(String texto) {
        this.nome = texto;
        return this;
    }

    TagLayout get(TagLayout tag) {
        return this.get(tag.nome);
    }

    TagLayout get(String strfilho) {
        TagLayout fi = null;
        for (TagLayout filho : this.filhos) {
            if (!filho.nome.equalsIgnoreCase(strfilho)) continue;
            fi = filho;
            break;
        }
        return fi;
    }

    String getAtr(String stratt) {
        String ret = null;
        Object att = this.atributos.get(stratt);
        if (att != null) {
            ret = att.toString();
        }
        return ret;
    }

    Integer getInt(String stratt) {
        Integer ret = null;
        Object obj = this.atributos.get(stratt);
        if (obj == null) {
            return null;
        }
        ret = obj instanceof Number ? (obj instanceof Integer ? (Integer)obj : Integer.valueOf(((Number)obj).intValue())) : Integer.valueOf(Integer.parseInt(obj.toString()));
        return ret;
    }

    Object getObj(String stratt) {
        return this.atributos.get(stratt);
    }

    Object getValue(String nome) {
        TagLayout fi;
        Object ret = null;
        ret = this.atributos.get(nome);
        if (ret == null && (fi = this.get(nome)) != null) {
            ret = fi.getValue();
        }
        return ret;
    }

    public TagLayout(String nome) {
        this.nome = nome;
        this.filhos = new ArrayList<TagLayout>();
        this.atributos = new TreeMap<String, Object>();
    }

    public TagLayout setAttr(String nome, Object valor) {
        return this.atr(nome, valor);
    }

    public TagLayout atr(String nome, Object valor) {
        this.atributos.put(nome, valor);
        return this;
    }

    public TagLayout type(Class tipo) {
        return this.setAttr(tipo);
    }

    public TagLayout filler(IFiller padding) {
        return this.setAttr(padding);
    }

    public TagLayout padding(IFiller padding) {
        return this.setAttr(padding);
    }

    public TagLayout format(Format padding) {
        return this.setAttr(padding);
    }

    public TagLayout valLen(String val) {
        this.value(val);
        this.length(val.length());
        return this;
    }

    public TagLayout val(String val) {
        this.value(val);
        this.length(val.length());
        return this;
    }

    public TagLayout id(boolean bol) {
        return this.setAttr(bol);
    }

    public TagLayout truncate(boolean bol) {
        return this.setAttr(bol);
    }

    public TagLayout apenasDigitos(boolean bol) {
        return this.setAttr(bol);
    }

    public TagLayout length(int len) {
        return this.setAttr(len);
    }

    public TagLayout position(int len) {
        return this.setAttr(len);
    }

    public TagLayout value(Object len) {
        return this.setAttr(len);
    }

    public TagLayout withValue(Object texto) {
        this.value = texto;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public String getNome() {
        return this.nome;
    }

    public TagLayout with(TagLayout ... filhos) {
        if (filhos != null) {
            for (TagLayout filho : filhos) {
                this.filhos.add(filho);
            }
        }
        return this;
    }

    public TagLayout insertAfter(TagLayout holder, TagLayout ... filhos) {
        int indexOf;
        if (holder != null && filhos != null && (indexOf = this.filhos.indexOf(holder)) >= 0) {
            this.filhos.addAll(indexOf + 1, Arrays.asList(filhos));
        }
        return this;
    }

    public TagLayout insertBefore(TagLayout holder, TagLayout ... filhos) {
        int indexOf;
        if (holder != null && filhos != null && (indexOf = this.filhos.indexOf(holder)) > 0) {
            this.filhos.addAll(indexOf, Arrays.asList(filhos));
        }
        return this;
    }

    protected TagLayout setAttr(Object valor) {
        String nomeMetodoAnterior = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.atr(nomeMetodoAnterior, valor);
        return this;
    }

    public TagLayout clone() {
        return (TagLayout)SerializationUtils.clone((Serializable)this);
    }

    public TagLayout cloneReadonly() {
        TagLayout clone = this.clone();
        this.colecoesImutaveis(clone);
        return clone;
    }

    private void colecoesImutaveis(TagLayout clone) {
        clone.atributos = Collections.unmodifiableMap(clone.atributos);
        clone.filhos = Collections.unmodifiableList(clone.filhos);
        for (TagLayout tf : clone.filhos) {
            this.colecoesImutaveis(tf);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.nome);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagLayout other = (TagLayout)obj;
        return Objects.equals(this.nome, other.nome);
    }

    public String toString() {
        return "Tag{" + this.nome + "=" + this.value + " filhos=" + this.filhos + "}";
    }

    public static class TagCreator {
        public static TagLayout field(String texto) {
            return TagCreator.tag(texto);
        }

        public static TagLayout fbancoCodigo() {
            return TagCreator.field("bancoCodigo").padding(Fillers.ZERO_LEFT).length(3);
        }

        public static TagLayout fbancoNome() {
            return TagCreator.field("bancoNome").padding(Fillers.WHITE_SPACE_RIGHT);
        }

        public static TagLayout fagencia() {
            return TagCreator.field("agencia").length(6).padding(Fillers.ZERO_LEFT).apenasDigitos(true);
        }

        public static TagLayout favorecidoAgencia() {
            return TagCreator.field("favorecidoAgencia").length(6).padding(Fillers.ZERO_LEFT).apenasDigitos(true);
        }

        public static TagLayout fdac() {
            return TagCreator.field("dac").length(1);
        }

        public static TagLayout fcodigoBarras() {
            return TagCreator.field("codigoBarras").padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fsacadoNome() {
            return TagCreator.field("sacadoNome").truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).length(30);
        }

        public static TagLayout fendereco() {
            return TagCreator.field("endereco").truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).length(40);
        }

        public static TagLayout fcomplemento() {
            return TagCreator.field("complemento").truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).length(15);
        }

        public static TagLayout fnumero() {
            return TagCreator.field("numero").truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).length(5);
        }

        public static TagLayout fbairro() {
            return TagCreator.field("bairro").truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).length(40);
        }

        public static TagLayout fcep() {
            return TagCreator.field("cep").truncate(true).padding(Fillers.ZERO_RIGHT).length(8).apenasDigitos(true);
        }

        public static TagLayout fcidade() {
            return TagCreator.field("cidade").truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).length(15);
        }

        public static TagLayout fuf() {
            return TagCreator.field("uf").truncate(true).length(2).padding(Fillers.WHITE_SPACE_RIGHT);
        }

        public static TagLayout fmovimentoCodigo() {
            return TagCreator.field("movimentoCodigo").padding(Fillers.ZERO_LEFT).length(2);
        }

        public static TagLayout fsacadoCpf() {
            return TagCreator.field("sacadoCpf").length(14).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fconvenio() {
            return TagCreator.field("convenio").apenasDigitos(true).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout ftipoInscricaoCedente() {
            return TagCreator.field("tipoInscricaoCedente").length(1).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout ftipoInscricao() {
            return TagCreator.field("tipoInscricao").length(1).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout favorecidoTipoInscricao() {
            return TagCreator.field("favorecidoTipoInscricao").length(1).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout favorecidoInscricao() {
            return TagCreator.field("favorecidoInscricao").padding(Fillers.ZERO_LEFT).length(14).apenasDigitos(true);
        }

        public static TagLayout fcedenteCnpj() {
            return TagCreator.field("cedenteCnpj").padding(Fillers.ZERO_LEFT).length(14).apenasDigitos(true);
        }

        public static TagLayout fcedenteNome() {
            return TagCreator.field("cedenteNome").truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).length(30);
        }

        public static TagLayout ffavorecidoNome() {
            return TagCreator.field("favorecidoNome").truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).length(30);
        }

        public static TagLayout ffavorecidoCPFCNPJ() {
            return TagCreator.field("favorecidoCPFCNPJ").truncate(true).padding(Fillers.ZERO_LEFT).length(20).apenasDigitos(true);
        }

        public static TagLayout ffavorecidoCodigoBanco() {
            return TagCreator.fdata().nome("favorecidoCodigoBanco").filler(Fillers.ZERO_LEFT).value(0).apenasDigitos(true);
        }

        public static TagLayout ffavorecidoAgencia() {
            return TagCreator.fdata().nome("favorecidoAgencia").filler(Fillers.ZERO_LEFT).value(0).apenasDigitos(true);
        }

        public static TagLayout ffavorecidoConta() {
            return TagCreator.fdata().nome("favorecidoConta").filler(Fillers.ZERO_LEFT).value(0).apenasDigitos(true);
        }

        public static TagLayout fquantidadeRegistros() {
            return TagCreator.field("quantidadeRegistros").type(Number.class).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fquantidadeLotes() {
            return TagCreator.field("quantidadeLotes").type(Number.class).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fvalorTotalRegistros() {
            return TagCreator.field("valorTotalRegistros").type(Number.class).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fformaDeTransferencia() {
            return TagCreator.field("formaDeTransferencia").type(Number.class).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout focorrencias() {
            return TagCreator.field("ocorrencias").filler(Fillers.WHITE_SPACE_LEFT).length(10);
        }

        public static TagLayout frejeicoes() {
            return TagCreator.field("rejeicoes").length(10);
        }

        public static TagLayout flote() {
            return TagCreator.field("lote").length(4).type(Number.class).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fcodigoCarteira() {
            return TagCreator.field("codigoCarteira").length(1).type(Number.class);
        }

        public static TagLayout fcarteira() {
            return TagCreator.field("carteira").length(3).type(Number.class).filler(Fillers.ZERO_LEFT);
        }

        public static TagLayout fvalor() {
            return TagCreator.field("valor").length(15).type(Number.class).filler(Fillers.ZERO_LEFT);
        }

        public static TagLayout fvalorPagamento() {
            return TagCreator.field("valorPagamento").length(15).type(Number.class).filler(Fillers.ZERO_LEFT);
        }

        public static TagLayout fvalorOcorrencia() {
            return TagCreator.field("valorOcorrencia").length(15).type(Number.class).filler(Fillers.ZERO_LEFT);
        }

        public static TagLayout fvalorDesconto() {
            return TagCreator.fvalor().nome("valorDesconto").value(0);
        }

        public static TagLayout fvalorAbatimento() {
            return TagCreator.fvalor().nome("valorAbatimento").value(0);
        }

        public static TagLayout fvalorIOF() {
            return TagCreator.fvalor().nome("valorIOF").value(0);
        }

        public static TagLayout fvalorLiquido() {
            return TagCreator.fvalor().nome("valorLiquido").value(0);
        }

        public static TagLayout fvalorTarifaCustas() {
            return TagCreator.fvalor().nome("valorTarifaCustas").value(0);
        }

        public static TagLayout fvalorOutrasDespesas() {
            return TagCreator.fvalor().nome("valorOutrasDespesas").value(0);
        }

        public static TagLayout fvalorOutrasReceitas() {
            return TagCreator.fvalor().nome("valorOutrasReceitas").value(0);
        }

        public static TagLayout fvalorAcrescimo() {
            return TagCreator.fvalor().nome("valorAcresciomo").value(0);
        }

        public static TagLayout fcodigoAcrescimo() {
            return TagCreator.field("codigoAcrescimo").length(1).value(3);
        }

        public static TagLayout fcodigoDesconto() {
            return TagCreator.field("codigoDesconto").length(1).value(0);
        }

        public static TagLayout fcodigoProtesto() {
            return TagCreator.field("codigoProtesto").length(1).value(3);
        }

        public static TagLayout fcodigoBaixa() {
            return TagCreator.field("codigoBaixa").length(1).value(2);
        }

        public static TagLayout fliteralRemessa() {
            return TagCreator.field("literalRemessa").length(7).truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).value("REMESSA");
        }

        public static TagLayout fliteralRetorno() {
            return TagCreator.field("literalRetorno").length(7).truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).value("RETORNO");
        }

        public static TagLayout fliteralServico() {
            return TagCreator.field("literalServico").length(15).truncate(true).padding(Fillers.WHITE_SPACE_RIGHT).value("COBRANCA");
        }

        public static TagLayout fnumeroDocumento() {
            return TagCreator.field("numeroDocumento").type(Number.class).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fnumeroRemessa() {
            return TagCreator.field("numeroRemessa").type(Number.class).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout ftipoDocumento() {
            return TagCreator.field("tipoDocumento").length(1).value(1);
        }

        public static TagLayout ftipoEmissaoBoleto() {
            return TagCreator.field("tipoEmissaoBoleto").length(1).value(2);
        }

        public static TagLayout ftipoDistribuicaoBoleto() {
            return TagCreator.field("tipoDistribuicaoBoleto").length(1).value(2);
        }

        public static TagLayout fespecieTitulo() {
            return TagCreator.field("especieTitulo").length(2).value("02");
        }

        public static TagLayout faceite() {
            return TagCreator.field("aceite").length(1).value("N");
        }

        public static TagLayout fnossoNumero() {
            return TagCreator.field("nossoNumero").type(Number.class).filler(Fillers.ZERO_LEFT);
        }

        public static TagLayout fsequencialRegistro() {
            return TagCreator.field("sequencialRegistro").length(5).type(Number.class).filler(Fillers.ZERO_LEFT);
        }

        public static TagLayout fmovimentoTipo() {
            return TagCreator.field("movimentoTipo").length(1);
        }

        public static TagLayout fcodigoMoeda() {
            return TagCreator.field("codigoMoeda").value("09").length(2);
        }

        public static TagLayout fforma() {
            return TagCreator.field("forma").length(2).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fzero() {
            return TagCreator.field("").filler(Fillers.ZERO_LEFT);
        }

        public static TagLayout fsegmento() {
            return TagCreator.field("segmento").length(1);
        }

        public static TagLayout fidOpcional() {
            return TagCreator.field("idOpcional").length(2);
        }

        public static TagLayout fbranco() {
            return TagCreator.field("branco").filler(Fillers.WHITE_SPACE_LEFT);
        }

        public static TagLayout fconta() {
            return TagCreator.field("conta").length(13).padding(Fillers.ZERO_LEFT).apenasDigitos(true);
        }

        public static TagLayout favorecidoConta() {
            return TagCreator.field("favorecidoConta").length(13).padding(Fillers.ZERO_LEFT).apenasDigitos(true);
        }

        public static TagLayout fcodigoRegistro() {
            return TagCreator.field("codigoRegistro").length(1).id(true);
        }

        public static TagLayout foperacao() {
            return TagCreator.field("operacao").length(1);
        }

        public static TagLayout fservico() {
            return TagCreator.field("servico").length(2).padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fcodigoRetorno() {
            return TagCreator.field("codigoRetorno").length(1);
        }

        public static TagLayout fsequencialArquivo() {
            return TagCreator.field("sequencialArquivo").padding(Fillers.ZERO_LEFT);
        }

        public static TagLayout fcodigoArquivo() {
            return TagCreator.field("codigoArquivo").length(1);
        }

        public static TagLayout fcodigoOcorrencia() {
            return TagCreator.field("codigoOcorrencia").length(1);
        }

        public static TagLayout fdata() {
            return TagCreator.field("data").filler(Fillers.ZERO_LEFT).length(8).format(new SimpleDateFormat("ddMMyyyy"));
        }

        public static TagLayout fdataAcrescimo() {
            return TagCreator.fdata().nome("dataAcrescimo").filler(Fillers.ZERO_LEFT).value(0);
        }

        public static TagLayout fdataDesconto() {
            return TagCreator.fdata().nome("dataDesconto").filler(Fillers.ZERO_LEFT).value(0);
        }

        public static TagLayout fdataPagamento() {
            return TagCreator.fdata().nome("dataPgamento").filler(Fillers.ZERO_LEFT).value(0);
        }

        public static TagLayout fdataGeracao() {
            return TagCreator.field("dataGeracao").type(Date.class).format(new SimpleDateFormat("ddMMyyyy")).length(8).filler(Fillers.ZERO_LEFT).value(0);
        }

        public static TagLayout fdataOcorrencia() {
            return TagCreator.field("dataOcorrencia").length(8).format(new SimpleDateFormat("ddMMyyyy"));
        }

        public static TagLayout fdataCredito() {
            return TagCreator.field("dataCredito").length(8).format(new SimpleDateFormat("ddMMyyyy"));
        }

        public static TagLayout fdataVencimento() {
            return TagCreator.field("dataVencimento").length(8).format(new SimpleDateFormat("ddMMyyyy"));
        }

        public static TagLayout cabecalho(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout cabecalhoLote(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout titulo(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoA(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoB(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoJ(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoJ52(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoU(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoT(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoP(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoQ(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalheSegmentoR(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout detalhe(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout rodape(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout rodapeLote(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout group(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout descricao(String texto) {
            return TagCreator.tagin().withValue(texto);
        }

        public static TagLayout versao(String texto) {
            return TagCreator.tagin().withValue(texto);
        }

        public static TagLayout nome(String texto) {
            return TagCreator.tagin().withValue(texto);
        }

        public static TagLayout layout(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        public static TagLayout banco(IBanco banco) {
            return TagCreator.tagin().withValue(banco);
        }

        public static TagLayout banco(String banco) {
            return TagCreator.tagin().withValue(banco);
        }

        public static TagLayout servico(CNABServico servico) {
            return TagCreator.tagin().withValue((Object)servico);
        }

        public static TagLayout cnab(CNAB cnab) {
            return TagCreator.tagin().withValue((Object)cnab);
        }

        public static TagLayout flatfile(TagLayout ... filhos) {
            return TagCreator.tagin().with(filhos);
        }

        private static TagLayout tagin() {
            String nomeMetodoAnterior = Thread.currentThread().getStackTrace()[2].getMethodName();
            return TagCreator.tag(nomeMetodoAnterior);
        }

        public static TagLayout tag(String nome) {
            return new TagLayout(nome);
        }
    }
}

