/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo;

import java.util.HashMap;
import java.util.Map;
import org.jrimum.domkee.banco.Banco;
import org.jrimum.domkee.banco.CodigoDeCompensacaoBACEN;
import org.jrimum.domkee.pessoa.CNPJ;

public enum BancosSuportados {
    BANCO_DO_BRASIL("001", "00000000000191", "BANCO DO BRASIL S.A.", "Banco do Brasil - Banco M\u00faltiplo"),
    BANCO_DO_NORDESTE_DO_BRASIL("004", "07237373000120", "BANCO DO NORDESTE DO BRASIL S.A.", "Banco M\u00faltiplo"),
    BANCO_DO_ESTADO_DO_ESPIRITO_SANTO("021", "28127603000178", "BANCO DO ESTADO DO ESPIRITO SANTO S.A.", "Banco M\u00faltiplo"),
    BANCO_SANTANDER("033", "90400888000142", "BANCO SANTANDER (BRASIL) S. A.", "Banco M\u00fatiplo"),
    BANCO_DO_ESTADO_DO_RIO_GRANDE_DO_SUL("041", "92702067000196", "BANCO DO ESTADO DO RIO GRANDE DO SUL S.A.", "Banco M\u00faltiplo"),
    BANCO_DE_BRASILIA("070", "00000208000100", "BRB- Banco de Bras\u00edlia S.A.", "Banco M\u00faltiplo"),
    BANCO_INTEMEDIUM("077", "00416968000101", "BANCO INTERMEDIUM S.A.", "Banco M\u00faltiplo"),
    CECRED("085", "05.463.212/0001-29", "COOPERATIVA CENTRAL DE CR\u00c9DITO URBANO - CECRED", "Cooperativa de Cr\u00e9dito"),
    CAIXA_ECONOMICA_FEDERAL("104", "00360305000104", "CAIXA ECONOMICA FEDERAL", "Caixa Econ\u00f4mica Federal"),
    UNICRED("136", "00315557000111", "Unicred Do Brasil", "Instituicao Financeira Cooperativa"),
    BANCO_BRADESCO("237", "60746948000112", "BANCO BRADESCO S.A.", "Banco M\u00faltiplo"),
    BANCO_ITAU("341", "60701190000104", "BANCO ITA\u00da S.A.", "Banco M\u00faltiplo"),
    BANCO_ABN_AMRO_REAL("356", "33066408000115", "BANCO ABN AMRO REAL S.A.", "Banco M\u00faltiplo"),
    MERCANTIL_DO_BRASIL("389", "17184037000110", "BANCO MERCANTIL DO BRASIL S.A.", "Banco M\u00faltiplo"),
    HSBC("399", "01701201000189", "HSBC BANK BRASIL S.A.", "Banco M\u00faltiplo"),
    UNIBANCO("409", "33700394000140", "UNIBANCO-UNIAO DE BANCOS BRASILEIROS S.A.", "Banco M\u00faltiplo"),
    BANCO_SAFRA("422", "58160789000128", "BANCO SAFRA S.A.", "Banco M\u00faltiplo"),
    CITIBANK("745", "33479023000180", "BANCO CITIBANK S.A.", "Banco M\u00faltiplo"),
    BANCO_SICREDI("748", "01181521000155", "BANCO COOPERATIVO SICREDI S.A.", "Banco M\u00fatiplo Cooperativo"),
    BANCO_RURAL("453", "58160789000128", "BANCO RURAL S.A.", "Banco M\u00faltiplo"),
    BANCO_DAYCOVAL("707", "62232889000190", "BANCO DAYCOVAL S.A.", "Banco M\u00faltiplo"),
    BANCOOB("756", "02038232000164", "BANCO COOPERATIVO DO BRASIL S.A. - BANCOOB", "Banco Comercial Cooperativo");

    public static final Map<String, BancosSuportados> suportados;
    private String codigoDeCompensacaoBACEN;
    private String cNPJ;
    private String instituicao;
    private String segmento;
    private static final Map<String, Banco> CACHE_INSTANCE;

    private BancosSuportados(String codigoDeCompensacaoBACEN, String cnpj, String instituicao, String segmento) {
        this.codigoDeCompensacaoBACEN = codigoDeCompensacaoBACEN;
        this.cNPJ = cnpj;
        this.instituicao = instituicao;
        this.segmento = segmento;
    }

    public static boolean isSuportado(String codigoDeCompensacao) {
        return suportados.containsKey(codigoDeCompensacao);
    }

    public Banco create() {
        return new Banco(new CodigoDeCompensacaoBACEN(this.codigoDeCompensacaoBACEN), this.instituicao, new CNPJ(this.cNPJ), this.segmento);
    }

    public String getCodigoDeCompensacao() {
        return this.codigoDeCompensacaoBACEN;
    }

    public String getCNPJ() {
        return this.cNPJ;
    }

    public String getInstituicao() {
        return this.instituicao;
    }

    public String getSegmento() {
        return this.segmento;
    }

    public static Banco instancia(String numero) {
        Banco banco = CACHE_INSTANCE.get(numero);
        if (banco == null) {
            BancosSuportados suportado = suportados.get(numero);
            if (suportado != null) {
                banco = suportado.create();
            }
            CACHE_INSTANCE.put(numero, banco);
        }
        return banco;
    }

    static {
        suportados = new HashMap<String, BancosSuportados>(BancosSuportados.values().length);
        suportados.put(BancosSuportados.BANCO_DO_BRASIL.codigoDeCompensacaoBACEN, BANCO_DO_BRASIL);
        suportados.put(BancosSuportados.BANCO_DO_NORDESTE_DO_BRASIL.codigoDeCompensacaoBACEN, BANCO_DO_NORDESTE_DO_BRASIL);
        suportados.put(BancosSuportados.CAIXA_ECONOMICA_FEDERAL.codigoDeCompensacaoBACEN, CAIXA_ECONOMICA_FEDERAL);
        suportados.put(BancosSuportados.BANCO_BRADESCO.codigoDeCompensacaoBACEN, BANCO_BRADESCO);
        suportados.put(BancosSuportados.BANCO_ABN_AMRO_REAL.codigoDeCompensacaoBACEN, BANCO_ABN_AMRO_REAL);
        suportados.put(BancosSuportados.UNIBANCO.codigoDeCompensacaoBACEN, UNIBANCO);
        suportados.put(BancosSuportados.HSBC.codigoDeCompensacaoBACEN, HSBC);
        suportados.put(BancosSuportados.BANCO_ITAU.codigoDeCompensacaoBACEN, BANCO_ITAU);
        suportados.put(BancosSuportados.BANCO_SAFRA.codigoDeCompensacaoBACEN, BANCO_SAFRA);
        suportados.put(BancosSuportados.BANCO_DO_ESTADO_DO_RIO_GRANDE_DO_SUL.codigoDeCompensacaoBACEN, BANCO_DO_ESTADO_DO_RIO_GRANDE_DO_SUL);
        suportados.put(BancosSuportados.MERCANTIL_DO_BRASIL.codigoDeCompensacaoBACEN, MERCANTIL_DO_BRASIL);
        suportados.put(BancosSuportados.BANCO_DO_ESTADO_DO_ESPIRITO_SANTO.codigoDeCompensacaoBACEN, BANCO_DO_ESTADO_DO_ESPIRITO_SANTO);
        suportados.put(BancosSuportados.BANCO_RURAL.codigoDeCompensacaoBACEN, BANCO_RURAL);
        suportados.put(BancosSuportados.BANCO_SANTANDER.codigoDeCompensacaoBACEN, BANCO_SANTANDER);
        suportados.put(BancosSuportados.BANCO_INTEMEDIUM.codigoDeCompensacaoBACEN, BANCO_INTEMEDIUM);
        suportados.put(BancosSuportados.BANCO_SICREDI.codigoDeCompensacaoBACEN, BANCO_SICREDI);
        suportados.put(BancosSuportados.BANCOOB.codigoDeCompensacaoBACEN, BANCOOB);
        suportados.put(BancosSuportados.CITIBANK.codigoDeCompensacaoBACEN, CITIBANK);
        suportados.put(BancosSuportados.BANCO_DE_BRASILIA.codigoDeCompensacaoBACEN, BANCO_DE_BRASILIA);
        suportados.put(BancosSuportados.CECRED.codigoDeCompensacaoBACEN, CECRED);
        suportados.put(BancosSuportados.UNICRED.codigoDeCompensacaoBACEN, UNICRED);
        suportados.put(BancosSuportados.BANCO_DAYCOVAL.codigoDeCompensacaoBACEN, BANCO_DAYCOVAL);
        CACHE_INSTANCE = new HashMap<String, Banco>();
    }
}

