/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo;

import java.awt.Image;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.CodigoDeBarras;
import org.jrimum.bopepo.LinhaDigitavel;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.CampoLivreFactory;
import org.jrimum.bopepo.campolivre.NotSupportedBancoException;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.bopepo.view.BoletoCampo;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.utilix.DateFormat;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

public class Boleto {
    protected static Logger log = Logger.getLogger(Boleto.class);
    protected Titulo titulo;
    protected Date dataDeProcessamento;
    protected CodigoDeBarras codigoDeBarras;
    protected LinhaDigitavel linhaDigitavel;
    protected CampoLivre campoLivre;
    protected String localPagamento;
    protected String instrucaoAoSacado;
    protected String instrucao1;
    protected String instrucao2;
    protected String instrucao3;
    protected String instrucao4;
    protected String instrucao5;
    protected String instrucao6;
    protected String instrucao7;
    protected String instrucao8;
    protected Map<String, String> textosExtras;
    protected Map<String, Image> imagensExtras;

    public Boleto() {
    }

    public Boleto(Titulo titulo) throws IllegalArgumentException, NotSupportedBancoException, NotSupportedCampoLivreException {
        this.processFromTitulo(titulo);
    }

    protected void processFromTitulo(Titulo titulo1) throws NotSupportedCampoLivreException, NotSupportedBancoException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Instanciando boleto");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("titulo instance : " + titulo1));
        }
        if (Objects.isNotNull(titulo1)) {
            this.setTitulo(titulo1);
            this.setCampoLivre(CampoLivreFactory.create(titulo1));
            this.load();
            if (log.isDebugEnabled()) {
                log.debug((Object)("boleto instance : " + this));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"T\u00edtulo Nulo - Valor N\u00e3o Permitido!");
            }
            Exceptions.throwIllegalArgumentException("T\u00edtulo nulo!");
        }
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            log.trace((Object)("Boleto Instanciado : " + this));
        }
    }

    public Boleto(Titulo titulo, CampoLivre campoLivre) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Instanciando boleto");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("titulo instance : " + titulo));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("campoLivre instance : " + campoLivre));
        }
        if (Objects.isNotNull(titulo)) {
            this.setTitulo(titulo);
            this.setCampoLivre(campoLivre);
            this.load();
            if (log.isDebugEnabled()) {
                log.debug((Object)("boleto instance : " + this));
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException("T\u00edtulo nulo!");
            log.error((Object)"Valor N\u00e3o Permitido!", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            log.trace((Object)("Boleto Instanciado : " + this));
        }
    }

    protected void load() {
        this.codigoDeBarras = new CodigoDeBarras(this.titulo, this.campoLivre);
        this.linhaDigitavel = new LinhaDigitavel(this.codigoDeBarras);
        this.dataDeProcessamento = new Date();
        if (log.isInfoEnabled()) {
            log.info((Object)("Data de Processamento do Boleto : " + DateFormat.DDMMYYYY_B.format(this.dataDeProcessamento)));
        }
    }

    public CampoLivre getCampoLivre() {
        return this.campoLivre;
    }

    private void setCampoLivre(CampoLivre campoLivre) {
        Objects.checkNotNull(campoLivre);
        int length = ((String)campoLivre.write()).length();
        if (length == CampoLivre.STRING_LENGTH) {
            this.campoLivre = campoLivre;
        } else if (length > CampoLivre.STRING_LENGTH) {
            Exceptions.throwIllegalArgumentException("O tamanho da String [" + length + "] \u00e9 maior que o especificado [" + CampoLivre.STRING_LENGTH + "]!");
        } else {
            Exceptions.throwIllegalArgumentException("O tamanho da String [" + length + "] \u00e9 menor que o especificado [" + CampoLivre.STRING_LENGTH + "]!");
        }
    }

    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
    }

    public Date getDataDeProcessamento() {
        return this.dataDeProcessamento;
    }

    public void setDataDeProcessamento(Date dataDeProcessamento) {
        this.dataDeProcessamento = dataDeProcessamento;
    }

    public CodigoDeBarras getCodigoDeBarras() {
        return this.codigoDeBarras;
    }

    public void setCodigoDeBarras(CodigoDeBarras codigoDeBarras) {
        this.codigoDeBarras = codigoDeBarras;
    }

    public LinhaDigitavel getLinhaDigitavel() {
        return this.linhaDigitavel;
    }

    public void setLinhaDigitavel(LinhaDigitavel linhaDigitavel) {
        this.linhaDigitavel = linhaDigitavel;
    }

    public String getLocalPagamento() {
        return this.localPagamento;
    }

    public void setLocalPagamento(String localPagamento1) {
        this.localPagamento = localPagamento1;
    }

    public String getInstrucaoAoSacado() {
        return this.instrucaoAoSacado;
    }

    public void setInstrucaoAoSacado(String insturcaoAoSacado) {
        this.instrucaoAoSacado = insturcaoAoSacado;
    }

    public String getInstrucao1() {
        return this.instrucao1;
    }

    public void setInstrucao1(String instrucao1) {
        this.instrucao1 = instrucao1;
    }

    public String getInstrucao2() {
        return this.instrucao2;
    }

    public void setInstrucao2(String instrucao2) {
        this.instrucao2 = instrucao2;
    }

    public String getInstrucao3() {
        return this.instrucao3;
    }

    public void setInstrucao3(String instrucao3) {
        this.instrucao3 = instrucao3;
    }

    public String getInstrucao4() {
        return this.instrucao4;
    }

    public void setInstrucao4(String instrucao4) {
        this.instrucao4 = instrucao4;
    }

    public String getInstrucao5() {
        return this.instrucao5;
    }

    public void setInstrucao5(String instrucao5) {
        this.instrucao5 = instrucao5;
    }

    public String getInstrucao6() {
        return this.instrucao6;
    }

    public void setInstrucao6(String instrucao6) {
        this.instrucao6 = instrucao6;
    }

    public String getInstrucao7() {
        return this.instrucao7;
    }

    public void setInstrucao7(String instrucao7) {
        this.instrucao7 = instrucao7;
    }

    public String getInstrucao8() {
        return this.instrucao8;
    }

    public void setInstrucao8(String instrucao8) {
        this.instrucao8 = instrucao8;
    }

    public void sobrescrevaCampo(BoletoCampo campo, String conteudo) {
        this.addTextosExtras(campo.name(), conteudo);
    }

    public Map<String, String> getTextosExtras() {
        return this.textosExtras;
    }

    public void setTextosExtras(Map<String, String> textosExtras) {
        this.textosExtras = textosExtras;
    }

    public void addTextosExtras(String campo, String conteudo) {
        if (Objects.isNull(this.getTextosExtras())) {
            this.setTextosExtras(new HashMap<String, String>());
        }
        this.getTextosExtras().put(campo, conteudo);
    }

    public Map<String, Image> getImagensExtras() {
        return this.imagensExtras;
    }

    public void setImagensExtras(Map<String, Image> imagensExtras) {
        this.imagensExtras = imagensExtras;
    }

    public void addImagensExtras(String campo, Image conteudo) {
        if (Objects.isNull(this.getImagensExtras())) {
            this.setImagensExtras(new HashMap<String, Image>());
        }
        this.getImagensExtras().put(campo, conteudo);
    }

    public String toString() {
        return Objects.toString(this);
    }
}

