/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.bopepo.CodigoDeBarrasException;
import org.jrimum.bopepo.LinhaDigitavelException;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.vallia.BoletoLinhaDigitavelDV;

public final class BoletoUtil {
    private static final String CODIGO_DE_BARRAS_REGEX = "\\d{44}";
    private static final String LINHA_DIGITAVEL_NUMERICA_REGEX = "\\d{47}";
    private static final String LINHA_DIGITAVEL_FORMATADA_REGEX = "\\d{5}\\.\\d{5} \\d{5}\\.\\d{6} \\d{5}\\.\\d{6} \\d{1} \\d{14}";
    private static final String MSG_CODIGO_DE_BARRAS = "C\u00f3digo de barras inv\u00e1lido!";
    private static final String MSG_LINHA_INVALIDA = "Linha digit\u00e1vel inv\u00e1lida!";
    private static final String MSG_STR_VAZIA = "String vazia [ \"%s\" ] tamanho [ %d ].";
    private static final String MSG_NAO_FORMATADA = "String formatada [ \"%s\" ] de tamanho [ %d ] est\u00e1 fora do padr\u00e3o [ \"ddddd.ddddd ddddd.dddddd ddddd.dddddd d dddddddddddddd\" ] tamanho = 54.";
    private static final String MSG_STR_NUMERICA = "String num\u00e9rica [ \"%s\" ] de tamanho [ %d ] est\u00e1 fora do padr\u00e3o [ \"ddddddddddddddddddddddddddddddddddddddddddddddd\" ] tamanho = 47.";

    private BoletoUtil() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
    }

    public static String getCampoLivreDaLinhaDigitavelFormatada(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelFormatada(linhaDigitavel);
        String linhaNumerica = BoletoUtil.linhaDigitavelFormatadaEmNumerica(linhaDigitavel);
        return linhaNumerica.substring(4, 9) + linhaNumerica.substring(10, 20) + linhaNumerica.substring(21, 31);
    }

    public static String getValorDoTituloDaLinhaDigitavelFormatada(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelFormatada(linhaDigitavel);
        return BoletoUtil.linhaDigitavelFormatadaEmNumerica(linhaDigitavel).substring(37, 47);
    }

    public static String getFatorDeVencimentoDaLinhaDigitavelFormatada(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelFormatada(linhaDigitavel);
        return BoletoUtil.linhaDigitavelFormatadaEmNumerica(linhaDigitavel).substring(33, 37);
    }

    public static String getDigitoVerificadorGeralDaLinhaDigitavelFormatada(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelFormatada(linhaDigitavel);
        return BoletoUtil.linhaDigitavelFormatadaEmNumerica(linhaDigitavel).substring(32, 33);
    }

    public static String getCodigoDaMoedaDaLinhaDigitavelFormatada(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelFormatada(linhaDigitavel);
        return BoletoUtil.linhaDigitavelFormatadaEmNumerica(linhaDigitavel).substring(3, 4);
    }

    public static String getCodigoDoBancoDaLinhaDigitavelFormatada(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelFormatada(linhaDigitavel);
        return BoletoUtil.linhaDigitavelFormatadaEmNumerica(linhaDigitavel).substring(0, 3);
    }

    public static String getCampoLivreDoCodigoDeBarras(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        BoletoUtil.checkFormatoCodigoDeBarras(codigoDeBarras);
        return StringUtils.trim((String)codigoDeBarras).substring(19, 44);
    }

    public static String getValorDoTituloDoCodigoDeBarras(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        BoletoUtil.checkFormatoCodigoDeBarras(codigoDeBarras);
        return StringUtils.trim((String)codigoDeBarras).substring(9, 19);
    }

    public static String getFatorDeVencimentoDoCodigoDeBarras(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        BoletoUtil.checkFormatoCodigoDeBarras(codigoDeBarras);
        return StringUtils.trim((String)codigoDeBarras).substring(5, 9);
    }

    public static String getDigitoVerificadorGeralDoCodigoDeBarras(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        BoletoUtil.checkFormatoCodigoDeBarras(codigoDeBarras);
        return StringUtils.trim((String)codigoDeBarras).substring(4, 5);
    }

    public static String getCodigoDaMoedaDoCodigoDeBarras(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        BoletoUtil.checkFormatoCodigoDeBarras(codigoDeBarras);
        return StringUtils.trim((String)codigoDeBarras).substring(3, 4);
    }

    public static String getCodigoDoBancoDoCodigoDeBarras(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        BoletoUtil.checkFormatoCodigoDeBarras(codigoDeBarras);
        return StringUtils.trim((String)codigoDeBarras).substring(0, 3);
    }

    public static String codigoDeBarrasEmLinhaDigitavelFormatada(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        return BoletoUtil.linhaDigitavelNumericaEmFormatada(BoletoUtil.codigoDeBarrasEmLinhaDigitavelNumerica(codigoDeBarras));
    }

    public static String codigoDeBarrasEmLinhaDigitavelNumerica(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        BoletoUtil.checkFormatoCodigoDeBarras(codigoDeBarras);
        BoletoLinhaDigitavelDV calculadorDV = new BoletoLinhaDigitavelDV();
        StringBuilder linhaDigitavel = new StringBuilder();
        String c = StringUtils.trim((String)codigoDeBarras);
        linhaDigitavel.append(c.substring(0, 3));
        linhaDigitavel.append(c.substring(3, 4));
        linhaDigitavel.append(c.substring(19, 24));
        linhaDigitavel.append(calculadorDV.calcule(linhaDigitavel.toString()));
        linhaDigitavel.append(c.substring(24, 34));
        linhaDigitavel.append(calculadorDV.calcule(c.substring(24, 34)));
        linhaDigitavel.append(c.substring(34, 44));
        linhaDigitavel.append(calculadorDV.calcule(c.substring(34, 44)));
        linhaDigitavel.append(c.substring(4, 5));
        linhaDigitavel.append(c.substring(5, 19));
        return linhaDigitavel.toString();
    }

    public static String linhaDigitavelFormatadaEmCodigoDeBarras(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        return BoletoUtil.linhaDigitavelNumericaEmCodigoDeBarras(BoletoUtil.linhaDigitavelFormatadaEmNumerica(linhaDigitavel));
    }

    public static String linhaDigitavelNumericaEmCodigoDeBarras(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelNumerica(linhaDigitavel);
        StringBuilder codigoDeBarras = new StringBuilder();
        String l = StringUtils.trim((String)linhaDigitavel);
        codigoDeBarras.append(l.substring(0, 3));
        codigoDeBarras.append(l.substring(3, 4));
        codigoDeBarras.append(l.substring(32, 33));
        codigoDeBarras.append(l.substring(33, 47));
        codigoDeBarras.append(l.substring(4, 9));
        codigoDeBarras.append(l.substring(10, 20));
        codigoDeBarras.append(l.substring(21, 31));
        return codigoDeBarras.toString();
    }

    public static String linhaDigitavelFormatadaEmNumerica(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelFormatada(linhaDigitavel);
        return linhaDigitavel.replaceAll(" ", "").replaceAll("\\.", "");
    }

    public static String linhaDigitavelNumericaEmFormatada(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkFormatoLinhaDigitavelNumerica(linhaDigitavel);
        StringBuilder linhaFormatada = new StringBuilder();
        String l = StringUtils.trim((String)linhaDigitavel);
        linhaFormatada.append(l.substring(0, 5));
        linhaFormatada.append(".");
        linhaFormatada.append(l.substring(5, 10));
        linhaFormatada.append(" ");
        linhaFormatada.append(l.substring(10, 15));
        linhaFormatada.append(".");
        linhaFormatada.append(l.substring(15, 21));
        linhaFormatada.append(" ");
        linhaFormatada.append(l.substring(21, 26));
        linhaFormatada.append(".");
        linhaFormatada.append(l.substring(26, 32));
        linhaFormatada.append(" ");
        linhaFormatada.append(l.substring(32, 33));
        linhaFormatada.append(" ");
        linhaFormatada.append(l.substring(33));
        return linhaFormatada.toString();
    }

    public static boolean isCodigoDeBarrasValido(String codigoDeBarras) {
        if (StringUtils.isNotBlank((CharSequence)codigoDeBarras)) {
            return codigoDeBarras.trim().matches(CODIGO_DE_BARRAS_REGEX);
        }
        return false;
    }

    public static boolean isLinhaDigitavelFormatadaValida(String linhaDigitavel) {
        if (StringUtils.isNotBlank((CharSequence)linhaDigitavel)) {
            return linhaDigitavel.trim().matches(LINHA_DIGITAVEL_FORMATADA_REGEX);
        }
        return false;
    }

    public static boolean isLinhaDigitavelNumericaValida(String linhaDigitavel) {
        if (StringUtils.isNotBlank((CharSequence)linhaDigitavel)) {
            return linhaDigitavel.trim().matches(LINHA_DIGITAVEL_NUMERICA_REGEX);
        }
        return false;
    }

    public static void checkFormatoLinhaDigitavelFormatada(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkExistsLinhaDigitavel(linhaDigitavel);
        if (!linhaDigitavel.contains(".")) {
            throw new LinhaDigitavelException("Linha digit\u00e1vel inv\u00e1lida! " + String.format(MSG_NAO_FORMATADA, linhaDigitavel, linhaDigitavel.length()) + " A linha digit\u00e1vel formatada deve conter pontos!");
        }
        if (!linhaDigitavel.trim().contains(" ")) {
            throw new LinhaDigitavelException("Linha digit\u00e1vel inv\u00e1lida! " + String.format(MSG_NAO_FORMATADA, linhaDigitavel, linhaDigitavel.length()) + " A linha digit\u00e1vel formatada deve conter espa\u00e7os!");
        }
        if (!BoletoUtil.isLinhaDigitavelFormatadaValida(linhaDigitavel)) {
            throw new LinhaDigitavelException("Linha digit\u00e1vel inv\u00e1lida! " + String.format(MSG_NAO_FORMATADA, linhaDigitavel, linhaDigitavel.length()));
        }
    }

    public static void checkFormatoLinhaDigitavelNumerica(String linhaDigitavel) throws IllegalArgumentException, LinhaDigitavelException {
        BoletoUtil.checkExistsLinhaDigitavel(linhaDigitavel);
        if (!BoletoUtil.isLinhaDigitavelNumericaValida(linhaDigitavel)) {
            throw new LinhaDigitavelException("Linha digit\u00e1vel inv\u00e1lida! " + String.format(MSG_STR_NUMERICA, linhaDigitavel, linhaDigitavel.length()) + " A linha deve conter apenas 47 d\u00edgitos n\u00famericos [0-9]!");
        }
    }

    public static void checkFormatoCodigoDeBarras(String codigoDeBarras) throws IllegalArgumentException, CodigoDeBarrasException {
        BoletoUtil.checkExistsCodigoDeBarras(codigoDeBarras);
        if (!BoletoUtil.isCodigoDeBarrasValido(codigoDeBarras)) {
            throw new CodigoDeBarrasException("C\u00f3digo de barras inv\u00e1lido! " + String.format(MSG_STR_NUMERICA, codigoDeBarras, codigoDeBarras.length()) + " O c\u00f3digo de barras deve conter apenas 44 d\u00edgitos n\u00famericos [0-9]!");
        }
    }

    public static void checkExistsLinhaDigitavel(String linhaDigitavel) throws IllegalArgumentException {
        Objects.checkNotNull(linhaDigitavel, MSG_LINHA_INVALIDA);
        if (StringUtils.isBlank((CharSequence)linhaDigitavel)) {
            Exceptions.throwIllegalArgumentException("Linha digit\u00e1vel inv\u00e1lida! " + String.format(MSG_STR_VAZIA, linhaDigitavel, linhaDigitavel.length()));
        }
    }

    public static void checkExistsCodigoDeBarras(String codigoDeBarras) throws IllegalArgumentException {
        Objects.checkNotNull(codigoDeBarras, MSG_LINHA_INVALIDA);
        if (StringUtils.isBlank((CharSequence)codigoDeBarras)) {
            Exceptions.throwIllegalArgumentException("C\u00f3digo de barras inv\u00e1lido! " + String.format(MSG_STR_VAZIA, codigoDeBarras, codigoDeBarras.length()));
        }
    }
}

