/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.FatorDeVencimento;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.BlockOfFields;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.texgit.IFiller;
import org.jrimum.utilix.DecimalFormat;
import org.jrimum.utilix.Objects;
import org.jrimum.vallia.BoletoCodigoDeBarrasDV;

public class CodigoDeBarras
extends BlockOfFields {
    private static final long serialVersionUID = 748913164143978133L;
    private static Logger log = Logger.getLogger(CodigoDeBarras.class);
    private static final Integer FIELDS_LENGTH = 6;
    private static final Integer STRING_LENGTH = 44;
    private FixedField<String> codigoDoBanco;
    private FixedField<Integer> codigoDaMoeda;
    private FixedField<Integer> digitoVerificadorGeral;
    private FixedField<Integer> fatorDeVencimento;
    private FixedField<BigDecimal> valorNominalDoTitulo;
    private FixedField<String> campoLivre;

    CodigoDeBarras(Titulo titulo, CampoLivre campoLivre) {
        this.setLength(STRING_LENGTH);
        this.setSize(FIELDS_LENGTH);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Instanciando o CodigoDeBarras");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("titulo instance : " + titulo));
            log.debug((Object)("campoLivre instance : " + campoLivre));
        }
        this.codigoDoBanco = new FixedField<String>("0", (Integer)3, Fillers.ZERO_LEFT);
        this.codigoDaMoeda = new FixedField<Integer>(Integer.valueOf(0), (Integer)1, Fillers.ZERO_LEFT);
        this.digitoVerificadorGeral = new FixedField<Integer>(Integer.valueOf(0), (Integer)1, Fillers.ZERO_LEFT);
        this.fatorDeVencimento = new FixedField<Integer>(Integer.valueOf(0), (Integer)4, Fillers.ZERO_LEFT);
        this.valorNominalDoTitulo = new FixedField<BigDecimal>(new BigDecimal(0), 10, DecimalFormat.NUMBER_DD_BR.copy(), (IFiller)Fillers.ZERO_LEFT);
        this.campoLivre = new FixedField<String>("", 25);
        this.add(this.codigoDoBanco);
        this.add(this.codigoDaMoeda);
        this.add(this.digitoVerificadorGeral);
        this.add(this.fatorDeVencimento);
        this.add(this.valorNominalDoTitulo);
        this.add(this.campoLivre);
        ContaBancaria contaBancaria = titulo.getContaBancaria();
        this.codigoDoBanco.setValue(contaBancaria.getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado());
        this.codigoDaMoeda.setValue(titulo.getTipoDeMoeda().getCodigo());
        this.calculateAndSetFatorDeVencimento(titulo.getDataDoVencimento());
        this.valorNominalDoTitulo.setValue(titulo.getValor());
        this.campoLivre.setValue((String)campoLivre.write());
        this.calculateAndSetDigitoVerificadorGeral();
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            log.debug((Object)("codigoDeBarra instanciado : " + this));
        }
    }

    private void calculateAndSetDigitoVerificadorGeral() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Calculando Digito Verificador Geral");
        }
        BoletoCodigoDeBarrasDV calculadorDV = new BoletoCodigoDeBarrasDV();
        StringBuilder toCalculateDV = new StringBuilder(this.codigoDoBanco.write()).append(this.codigoDaMoeda.write()).append(this.fatorDeVencimento.write()).append(this.valorNominalDoTitulo.write()).append(this.campoLivre.write());
        this.digitoVerificadorGeral.setValue(calculadorDV.calcule(toCalculateDV.toString()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digito Verificador Geral calculado : " + this.digitoVerificadorGeral.getValue()));
        }
    }

    private void calculateAndSetFatorDeVencimento(Date vencimento) {
        this.fatorDeVencimento.setValue(FatorDeVencimento.toFator(vencimento));
    }

    FixedField<String> getCodigoDoBanco() {
        return this.codigoDoBanco;
    }

    void setCodigoDoBanco(FixedField<String> codigoDoBanco) {
        this.codigoDoBanco = codigoDoBanco;
    }

    FixedField<Integer> getCodigoDaMoeda() {
        return this.codigoDaMoeda;
    }

    void setCodigoDaMoeda(FixedField<Integer> codigoDaMoeda) {
        this.codigoDaMoeda = codigoDaMoeda;
    }

    FixedField<Integer> getDigitoVerificadorGeral() {
        return this.digitoVerificadorGeral;
    }

    void setDigitoVerificadorGeral(FixedField<Integer> digitoVerificadorGeral) {
        this.digitoVerificadorGeral = digitoVerificadorGeral;
    }

    FixedField<Integer> getFatorDeVencimento() {
        return this.fatorDeVencimento;
    }

    void setFatorDeVencimento(FixedField<Integer> fatorDeVencimento) {
        this.fatorDeVencimento = fatorDeVencimento;
    }

    FixedField<BigDecimal> getValorNominalDoTitulo() {
        return this.valorNominalDoTitulo;
    }

    void setValorNominalDoTitulo(FixedField<BigDecimal> valorNominalDoTitulo) {
        this.valorNominalDoTitulo = valorNominalDoTitulo;
    }

    FixedField<String> getCampoLivre() {
        return this.campoLivre;
    }

    void setCampoLivre(FixedField<String> campoLivre) {
        this.campoLivre = campoLivre;
    }

    public String toString() {
        return Objects.toString(this);
    }
}

