/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.jrimum.utilix.DateFormat;
import org.jrimum.utilix.Dates;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

public class FatorDeVencimento {
    private static final Calendar BASE_DO_FATOR_DE_VENCIMENTO = new GregorianCalendar(1997, 9, 7);
    private static final Date DATA_BASE_DO_FATOR_DE_VENCIMENTO = BASE_DO_FATOR_DE_VENCIMENTO.getTime();
    private static final Date DATA_LIMITE_DO_FATOR_DE_VENCIMENTO = new GregorianCalendar(2200, 1, 21).getTime();
    private static final int NUMERO_LIMITE_MINIMO_DO_FATOR_DE_VENCIMENTO = 999;
    private static final int NUMERO_LIMITE_MAXIMO_DO_FATOR_DE_VENCIMENTO = 9999;

    public static int toFator(Date data) throws IllegalArgumentException {
        if (Objects.isNull(data)) {
            return (Integer)Exceptions.throwIllegalArgumentException("Imposs\u00edvel realizar o c\u00e1lculo do fator de vencimento de uma data nula!");
        }
        Date dataTruncada = DateUtils.truncate((Date)data, (int)5);
        FatorDeVencimento.checkIntervalo(dataTruncada);
        return FatorDeVencimento.getFatorDeVencimentoTranformado(data);
    }

    public static Date toDate(int fator) throws IllegalArgumentException {
        FatorDeVencimento.checkIntervalo(fator);
        Calendar date = (Calendar)BASE_DO_FATOR_DE_VENCIMENTO.clone();
        date.add(6, fator);
        return DateUtils.truncate((Date)date.getTime(), (int)5);
    }

    public static List<Date> toDateList(int fator) throws IllegalArgumentException {
        FatorDeVencimento.checkIntervalo(fator);
        ArrayList<Date> listaDeDatas = new ArrayList<Date>();
        List<Integer> listaDeFatores = FatorDeVencimento.getListaDeFatores(fator);
        listaDeFatores.forEach(f -> listaDeDatas.add(FatorDeVencimento.toDate(f)));
        return listaDeDatas;
    }

    private static void checkIntervalo(Date dataVencimentoTruncada) throws IllegalArgumentException {
        if (dataVencimentoTruncada.before(DATA_BASE_DO_FATOR_DE_VENCIMENTO) || dataVencimentoTruncada.after(DATA_LIMITE_DO_FATOR_DE_VENCIMENTO)) {
            Exceptions.throwIllegalArgumentException(String.format("Para o c\u00e1lculo do fator de vencimento se faz necess\u00e1rio informar uma data entre %s e %s.", DateFormat.DDMMYYYY_B.format(DATA_BASE_DO_FATOR_DE_VENCIMENTO), DateFormat.DDMMYYYY_B.format(DATA_LIMITE_DO_FATOR_DE_VENCIMENTO)));
        }
    }

    private static void checkIntervalo(int fatorDeVencimento) throws IllegalArgumentException {
        if (fatorDeVencimento < 0) {
            Exceptions.throwIllegalArgumentException("Imposs\u00edvel transformar em data um fator menor que zero!");
        }
        if (fatorDeVencimento >= FatorDeVencimento.getFatorDeVencimentoReal(DATA_LIMITE_DO_FATOR_DE_VENCIMENTO)) {
            Exceptions.throwIllegalArgumentException("O fator de vencimento deve ser um n\u00famero at\u00e9 9999.");
        }
    }

    public static int getFatorDeVencimentoReal(Date data) {
        Date dataTruncada = DateUtils.truncate((Date)data, (int)5);
        return (int)Dates.calculeDiferencaEmDias(DATA_BASE_DO_FATOR_DE_VENCIMENTO, dataTruncada);
    }

    public static int getFatorDeVencimentoTranformado(Date data) {
        int fatorReal = FatorDeVencimento.getFatorDeVencimentoReal(data);
        if (fatorReal > 9999) {
            fatorReal = FatorDeVencimento.getValorTransformado(fatorReal);
        }
        return fatorReal;
    }

    public static int getValorTransformado(int valor) {
        if (valor <= 9999) {
            return valor;
        }
        int valorFinal = 999 + Math.floorMod(valor - 999, 9000);
        return valorFinal;
    }

    public static List<Integer> getListaDeFatores(int valor) {
        ArrayList<Integer> listaDeFatores = new ArrayList<Integer>();
        if (valor >= 10000) {
            int y = Math.floorDiv(valor - 999, 9000);
            int valorFinal = FatorDeVencimento.getValorTransformado(valor);
            listaDeFatores.add(valorFinal);
            for (int i = 1; i < y; ++i) {
                listaDeFatores.add(999 + i * 9000 + Math.floorMod(valor - 999, 9000));
            }
        }
        listaDeFatores.add(valor);
        return listaDeFatores;
    }
}

