/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo;

import java.awt.Image;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.CodigoDeBarras;
import org.jrimum.bopepo.LinhaDigitavel;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.NotSupportedBancoException;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Arrecadacao;
import org.jrimum.domkee.banco.TipoSeguimento;
import org.jrimum.utilix.DateUtil;
import org.jrimum.utilix.Objects;

public final class Guia {
    private static final long serialVersionUID = 4436063640418293021L;
    private static Logger log = Logger.getLogger(Guia.class);
    private Arrecadacao arrecadacao;
    private Date dataDeProcessamento;
    private CodigoDeBarras codigoDeBarras;
    private LinhaDigitavel linhaDigitavel;
    private CampoLivre campoLivre;
    private String localPagamento;
    private String instrucaoAoSacado;
    private String instrucaoAoCaixa1;
    private String instrucaoAoCaixa2;
    private String instrucaoAoCaixa3;
    private String instrucaoAoCaixa4;
    private String instrucaoAoCaixa5;
    private String instrucaoAoCaixa6;
    private String instrucaoAoCaixa7;
    private String instrucaoAoCaixa8;
    private Map<String, String> textosExtras;
    private Map<String, Image> imagensExtras;

    public Guia() {
    }

    public Guia(Arrecadacao arrecadacao) throws IllegalArgumentException, NotSupportedBancoException, NotSupportedCampoLivreException {
        try {
            Objects.checkNotNull(arrecadacao);
            Objects.checkNotNull(arrecadacao.getOrgaoRecebedor());
            Objects.checkNotNull((Object)arrecadacao.getOrgaoRecebedor().getTipoSeguimento());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (Objects.isNull(arrecadacao.getConvenio()) || Objects.isNull(arrecadacao.getConvenio().getBanco())) {
            throw new IllegalArgumentException("Como n\u00e3o h\u00e1 um banco especificado atrav\u00e9s do conv\u00eanio, a informa\u00e7\u00e3o do CAMPO LIVRE ter\u00e1 de ser informado manualmente.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Instanciando guia... ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Arrecadacao instance : " + arrecadacao));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CampoLivre instance : " + this.campoLivre));
        }
        this.setArrecadacao(arrecadacao);
        this.load();
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            log.trace((Object)("Guia instanciada : " + this));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Instanciando uma guia...");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Arrecadaca instance : " + arrecadacao));
        }
        if (Objects.isNotNull(arrecadacao)) {
            this.setArrecadacao(arrecadacao);
            this.load();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Guia instance : " + this));
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException("Guia nula!");
            log.error((Object)"Valor n\u00e3o permitido!", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            log.trace((Object)("Guia Instanciado : " + this));
        }
    }

    public Guia(Arrecadacao arrecadacao, CampoLivre campoLivre) {
        try {
            Objects.checkNotNull(arrecadacao);
            Objects.checkNotNull(arrecadacao.getOrgaoRecebedor());
            Objects.checkNotNull((Object)arrecadacao.getOrgaoRecebedor().getTipoSeguimento());
            Objects.checkNotNull(campoLivre);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Instanciando guia... ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Arrecadacao instance : " + arrecadacao));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CampoLivre instance : " + campoLivre));
        }
        this.setArrecadacao(arrecadacao);
        this.setCampoLivre(campoLivre, arrecadacao.getOrgaoRecebedor().getTipoSeguimento());
        this.load();
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            log.trace((Object)("Guia instanciada : " + this));
        }
    }

    private void load() {
        this.linhaDigitavel = new LinhaDigitavel(this.codigoDeBarras);
        this.dataDeProcessamento = new Date();
        log.info((Object)("Data de Processamento da Guia: " + DateUtil.FORMAT_DD_MM_YYYY.format(this.dataDeProcessamento)));
    }

    public CampoLivre getCampoLivre() {
        return this.campoLivre;
    }

    public void setCampoLivre(CampoLivre campoLivre, TipoSeguimento tipoSeguimento) {
        Objects.checkNotNull(campoLivre);
        Objects.checkNotNull((Object)tipoSeguimento);
        this.campoLivre = campoLivre;
    }

    public Arrecadacao getArrecadacao() {
        return this.arrecadacao;
    }

    public void setArrecadacao(Arrecadacao arrecadacao) {
        this.arrecadacao = arrecadacao;
    }

    public Date getDataDeProcessamento() {
        return this.dataDeProcessamento;
    }

    public void setDataDeProcessamento(Date dataDeProcessamento) {
        this.dataDeProcessamento = dataDeProcessamento;
    }

    public CodigoDeBarras getCodigoDeBarras() {
        return this.codigoDeBarras;
    }

    public void setCodigoDeBarras(CodigoDeBarras codigoDeBarras) {
        this.codigoDeBarras = codigoDeBarras;
    }

    public LinhaDigitavel getLinhaDigitavel() {
        return this.linhaDigitavel;
    }

    public void setLinhaDigitavel(LinhaDigitavel linhaDigitavel) {
        this.linhaDigitavel = linhaDigitavel;
    }

    public String getLocalPagamento() {
        return this.localPagamento;
    }

    public void setLocalPagamento(String localPagamento1) {
        this.localPagamento = localPagamento1;
    }

    public String getInstrucaoAoSacado() {
        return this.instrucaoAoSacado;
    }

    public String getInstrucaoAoCaixa1() {
        return this.instrucaoAoCaixa1;
    }

    public String getInstrucaoAoCaixa2() {
        return this.instrucaoAoCaixa2;
    }

    public String getInstrucaoAoCaixa3() {
        return this.instrucaoAoCaixa3;
    }

    public String getInstrucaoAoCaixa4() {
        return this.instrucaoAoCaixa4;
    }

    public String getInstrucaoAoCaixa5() {
        return this.instrucaoAoCaixa5;
    }

    public String getInstrucaoAoCaixa6() {
        return this.instrucaoAoCaixa6;
    }

    public String getInstrucaoAoCaixa7() {
        return this.instrucaoAoCaixa7;
    }

    public String getInstrucaoAoCaixa8() {
        return this.instrucaoAoCaixa8;
    }

    public void setInstrucaoAoCaixa1(String instrucaoAoCaixa1) {
        this.instrucaoAoCaixa1 = instrucaoAoCaixa1;
    }

    public void setInstrucaoAoCaixa2(String instrucaoAoCaixa2) {
        this.instrucaoAoCaixa2 = instrucaoAoCaixa2;
    }

    public void setInstrucaoAoCaixa3(String instrucaoAoCaixa3) {
        this.instrucaoAoCaixa3 = instrucaoAoCaixa3;
    }

    public void setInstrucaoAoCaixa4(String instrucaoAoCaixa4) {
        this.instrucaoAoCaixa4 = instrucaoAoCaixa4;
    }

    public void setInstrucaoAoCaixa5(String instrucaoAoCaixa5) {
        this.instrucaoAoCaixa5 = instrucaoAoCaixa5;
    }

    public void setInstrucaoAoCaixa6(String instrucaoAoCaixa6) {
        this.instrucaoAoCaixa6 = instrucaoAoCaixa6;
    }

    public void setInstrucaoAoCaixa7(String instrucaoAoCaixa7) {
        this.instrucaoAoCaixa7 = instrucaoAoCaixa7;
    }

    public void setInstrucaoAoCaixa8(String instrucaoAoCaixa8) {
        this.instrucaoAoCaixa8 = instrucaoAoCaixa8;
    }

    public void setInstrucaoAoSacado(String insturcaoAoSacado) {
        this.instrucaoAoSacado = insturcaoAoSacado;
    }

    public Map<String, String> getTextosExtras() {
        return this.textosExtras;
    }

    public void setTextosExtras(Map<String, String> textosExtras) {
        this.textosExtras = textosExtras;
    }

    public void addTextosExtras(String nome, String valor) {
        if (Objects.isNull(this.getTextosExtras())) {
            this.setTextosExtras(new HashMap<String, String>());
        }
        this.getTextosExtras().put(nome, valor);
    }

    public Map<String, Image> getImagensExtras() {
        return this.imagensExtras;
    }

    public void setImagensExtras(Map<String, Image> imagensExtras) {
        this.imagensExtras = imagensExtras;
    }

    public void addImagensExtras(String fieldName, Image image) {
        if (Objects.isNull(this.getImagensExtras())) {
            this.setImagensExtras(new HashMap<String, Image>());
        }
        this.getImagensExtras().put(fieldName, image);
    }

    public String toString() {
        return Objects.toString(this);
    }
}

