/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.ConfiguracaoJRimum;
import org.jrimum.bopepo.campolivre.AbstractCampoLivre;
import org.jrimum.bopepo.campolivre.CLBancoDoBrasilNN10;
import org.jrimum.bopepo.campolivre.CLBancoDoBrasilNN11;
import org.jrimum.bopepo.campolivre.CLBancoDoBrasilNN17Convenio6;
import org.jrimum.bopepo.campolivre.CLBancoDoBrasilNN17Convenio7;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Titulo;

abstract class AbstractCLBancoDoBrasil
extends AbstractCampoLivre {
    private static final long serialVersionUID = -7324315662526104153L;

    protected AbstractCLBancoDoBrasil(Integer fieldsLength) {
        super(fieldsLength);
    }

    protected static CampoLivre create(Titulo titulo) throws NotSupportedCampoLivreException {
        AbstractCLBancoDoBrasil.checkNossoNumero(titulo);
        AbstractCLBancoDoBrasil.checkNumeroDaContaNotNull(titulo);
        AbstractCLBancoDoBrasil.checkCodigoDoNumeroDaConta(titulo);
        switch (titulo.getNossoNumero().length()) {
            case 10: {
                return new CLBancoDoBrasilNN10(titulo);
            }
            case 11: {
                return new CLBancoDoBrasilNN11(titulo);
            }
            case 17: {
                if (titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta() < 1000000) {
                    return new CLBancoDoBrasilNN17Convenio6(titulo);
                }
                return new CLBancoDoBrasilNN17Convenio7().build(titulo);
            }
        }
        if (ConfiguracaoJRimum.preferirDefaultEmCampoLivre) {
            log.warn((Object)"N\u00e3o foi possivel identificar o tamanho do nosso numero usando default: CLBancoDoBrasilNN10");
            return new CLBancoDoBrasilNN10(titulo);
        }
        throw new NotSupportedCampoLivreException("Campo livre dipon\u00edvel somente para t\u00edtulos com nosso n\u00famero composto por 10 posi\u00e7\u00f5es(conv\u00eanio com 7), 11 posi\u00e7\u00f5es ou 17 posi\u00e7\u00f5es(conv\u00eanio com 6).");
    }
}

