/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCampoLivre;
import org.jrimum.bopepo.campolivre.CLBancoRuralCobrancaNaoRegistrada;
import org.jrimum.bopepo.campolivre.CLBancoRuralCobrancaNaoRegistradaSeguradora;
import org.jrimum.bopepo.campolivre.CLBancoRuralCobrancaRegistrada;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Titulo;

abstract class AbstractCLBancoRural
extends AbstractCampoLivre {
    private static final long serialVersionUID = -602454445158254612L;

    protected AbstractCLBancoRural(Integer fieldsLength) {
        super(fieldsLength);
    }

    protected static CampoLivre create(Titulo titulo) {
        AbstractCLBancoRural.checkCarteiraNotNull(titulo);
        AbstractCLBancoRural.checkRegistroDaCarteiraNotNull(titulo);
        switch (titulo.getContaBancaria().getCarteira().getTipoCobranca()) {
            case SEM_REGISTRO: {
                return AbstractCLBancoRural.campoSemRegistro(titulo);
            }
            case COM_REGISTRO: {
                return new CLBancoRuralCobrancaRegistrada(titulo);
            }
        }
        return null;
    }

    private static CampoLivre campoSemRegistro(Titulo titulo) {
        AbstractCLBancoRural.checkNossoNumero(titulo);
        switch (titulo.getNossoNumero().length()) {
            case 10: {
                return new CLBancoRuralCobrancaNaoRegistradaSeguradora(titulo);
            }
            case 15: {
                return new CLBancoRuralCobrancaNaoRegistrada(titulo);
            }
        }
        throw new NotSupportedCampoLivreException("Combran\u00e7a sem registro com campo livre dipon\u00edvel somente para t\u00edtulos com nosso n\u00famero composto por 10 posi\u00e7\u00f5es(ap\u00f3lice de seguro com I.O.S.) e 15 posi\u00e7\u00f5es(padr\u00e3o).");
    }
}

