/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCampoLivre;
import org.jrimum.bopepo.campolivre.CLBancoSafraCobrancaNaoRegistrada;
import org.jrimum.bopepo.campolivre.CLBancoSafraCobrancaRegistrada;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;

abstract class AbstractCLBancoSafra
extends AbstractCampoLivre {
    private static final long serialVersionUID = -555393808447532987L;
    private static final Integer CONSTANT_LENGTH_SISTEMA = 1;
    private static final Integer CONSTANT_VALUE_SISTEMA = 7;
    protected static final FixedField<Integer> SISTEMA_CONSTANT_FIELD = new FixedField<Integer>(CONSTANT_VALUE_SISTEMA, CONSTANT_LENGTH_SISTEMA);
    protected static final Integer TIPO_COBRANCA_FIELD_LENGTH = 1;

    protected AbstractCLBancoSafra(Integer fieldsLength) {
        super(fieldsLength);
    }

    protected static CampoLivre create(Titulo titulo) throws NotSupportedCampoLivreException {
        AbstractCLBancoSafra.checkCarteiraNotNull(titulo);
        AbstractCLBancoSafra.checkRegistroDaCarteiraNotNull(titulo);
        switch (titulo.getContaBancaria().getCarteira().getTipoCobranca()) {
            case COM_REGISTRO: {
                return new CLBancoSafraCobrancaRegistrada().build(titulo);
            }
            case SEM_REGISTRO: {
                return new CLBancoSafraCobrancaNaoRegistrada().build(titulo);
            }
        }
        throw new NotSupportedCampoLivreException("Campo livre dipon\u00edvel somente para t\u00edtulos com carteiras com tipo de cobran\u00e7a COM_REGISTRO ou SEM_REGISTRO.");
    }

    protected static enum TipoDeCobranca {
        BOLETO_EMITIDO_PELO_BANCO,
        DIRETA_BOLETO_EMITIDO_PELO_CLIENTE,
        EXPRESS_BOLETO_EMITIDO_PELO_CLIENTE;


        public int codigo() {
            switch (this) {
                case BOLETO_EMITIDO_PELO_BANCO: {
                    return 1;
                }
                case DIRETA_BOLETO_EMITIDO_PELO_CLIENTE: {
                    return 2;
                }
                case EXPRESS_BOLETO_EMITIDO_PELO_CLIENTE: {
                    return 4;
                }
            }
            return (Integer)Exceptions.throwIllegalStateException(String.format("Tipo \"%s\" sem c\u00f3digo atribu\u00eddo!", new Object[]{this}));
        }
    }
}

