/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCampoLivre;
import org.jrimum.bopepo.campolivre.CLBanrisulCobrancaNaoRegistrada;
import org.jrimum.bopepo.campolivre.CLBanrisulCobrancaRegistrada;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.IFixedField;
import org.jrimum.vallia.Modulo;

abstract class AbstractCLBanrisul
extends AbstractCampoLivre {
    private static final long serialVersionUID = -259398499475894938L;

    protected AbstractCLBanrisul(Integer fieldsLength) {
        super(fieldsLength);
    }

    protected static CampoLivre create(Titulo titulo) throws NotSupportedCampoLivreException {
        AbstractCLBanrisul.checkCarteiraNotNull(titulo);
        AbstractCLBanrisul.checkRegistroDaCarteiraNotNull(titulo);
        switch (titulo.getContaBancaria().getCarteira().getTipoCobranca()) {
            case COM_REGISTRO: {
                return new CLBanrisulCobrancaRegistrada(titulo);
            }
            case SEM_REGISTRO: {
                return new CLBanrisulCobrancaNaoRegistrada(titulo);
            }
        }
        throw new NotSupportedCampoLivreException("Campo livre dipon\u00edvel apenas para carteiras com ou sem cobran\u00e7a.");
    }

    protected String calculaDuploDigito(String seisPrimeirosCamposConcatenados) {
        int somaMod10 = Modulo.calculeSomaSequencialMod10(seisPrimeirosCamposConcatenados, 1, 2);
        byte restoMod10 = this.calculeRestoMod10(somaMod10);
        byte primeiroDV = this.calculePrimeiroDV(restoMod10);
        int somaMod11 = Modulo.calculeSomaSequencialMod11(seisPrimeirosCamposConcatenados + primeiroDV, 2, 7);
        byte restoMod11 = this.calculeRestoMod11(somaMod11);
        while (restoMod11 == 1) {
            primeiroDV = this.encontreValorValidoParaPrimeiroDV(primeiroDV);
            somaMod11 = Modulo.calculeSomaSequencialMod11(seisPrimeirosCamposConcatenados + primeiroDV, 2, 7);
            restoMod11 = this.calculeRestoMod11(somaMod11);
        }
        byte segundoDV = this.calculeSegundoDV(restoMod11);
        return String.valueOf(primeiroDV) + String.valueOf(segundoDV);
    }

    private byte calculeSegundoDV(byte restoMod11) {
        byte segundoDV = restoMod11 == 0 ? restoMod11 : (byte)(11 - restoMod11);
        return segundoDV;
    }

    private byte calculePrimeiroDV(byte restoMod10) {
        byte primeiroDV = restoMod10 == 0 ? (byte)0 : (byte)(10 - restoMod10);
        return primeiroDV;
    }

    private byte calculeRestoMod10(int somaMod10) {
        byte restoMod10 = somaMod10 < 10 ? (byte)somaMod10 : (byte)(somaMod10 % 10);
        return restoMod10;
    }

    private byte encontreValorValidoParaPrimeiroDV(byte primeiroDV) {
        byte novoValorDoPrimeiroDV = primeiroDV == 9 ? (byte)0 : (byte)(primeiroDV + 1);
        return novoValorDoPrimeiroDV;
    }

    private byte calculeRestoMod11(int somaMod11) {
        byte restoMod11 = somaMod11 < 11 ? (byte)somaMod11 : (byte)(somaMod11 % 11);
        return restoMod11;
    }

    protected String concateneOsCamposExistentesAteOMomento() {
        StringBuilder camposExistentesAteOMomentoConcatenados = new StringBuilder("");
        for (IFixedField field : this) {
            camposExistentesAteOMomentoConcatenados.append((String)field.write());
        }
        return camposExistentesAteOMomentoConcatenados.toString();
    }
}

