/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCampoLivre;
import org.jrimum.bopepo.campolivre.CLCaixaEconomicaFederalSICOBNossoNumero10;
import org.jrimum.bopepo.campolivre.CLCaixaEconomicaFederalSICOBNossoNumero14;
import org.jrimum.bopepo.campolivre.CLCaixaEconomicaFederalSIGCB;
import org.jrimum.bopepo.campolivre.CLCaixaEconomicaFederalSINCO;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Titulo;

abstract class AbstractCLCaixaEconomicaFederal
extends AbstractCampoLivre {
    private static final long serialVersionUID = -4104858478390595830L;

    protected AbstractCLCaixaEconomicaFederal(Integer fieldsLength) {
        super(fieldsLength);
    }

    protected static CampoLivre create(Titulo titulo) throws NotSupportedCampoLivreException {
        AbstractCLCaixaEconomicaFederal.checkNossoNumero(titulo);
        switch (titulo.getNossoNumero().length()) {
            case 10: {
                return new CLCaixaEconomicaFederalSICOBNossoNumero10(titulo);
            }
            case 14: {
                return new CLCaixaEconomicaFederalSICOBNossoNumero14().build(titulo);
            }
            case 15: {
                return new CLCaixaEconomicaFederalSIGCB(titulo);
            }
            case 17: {
                return new CLCaixaEconomicaFederalSINCO(titulo);
            }
        }
        throw new NotSupportedCampoLivreException(String.format("Campo Livre n\u00e3o suportado para o Nosso N\u00famero [%s] de tamanho [%s]. Apenas t\u00edtulos com Nosso N\u00famero de tamanho [%s] s\u00e3o suportados (SICOB, SIGCB e SINCO respectivamente).", titulo.getNossoNumero(), titulo.getNossoNumero().length(), "10,14,15,17"));
    }
}

