/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import java.util.HashSet;
import java.util.Set;
import org.jrimum.bopepo.campolivre.AbstractCampoLivre;
import org.jrimum.bopepo.campolivre.CLItauComCarteirasEspeciais;
import org.jrimum.bopepo.campolivre.CLItauPadrao;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.vallia.Modulo;

abstract class AbstractCLItau
extends AbstractCampoLivre {
    private static final long serialVersionUID = -3082903872777434482L;
    private static final Set<Integer> CARTEIRAS_ESPECIAIS = new HashSet<Integer>(8);

    protected AbstractCLItau(Integer fieldsLength) {
        super(fieldsLength);
    }

    protected static CampoLivre create(Titulo titulo) {
        AbstractCLItau.checkCarteiraNotNull(titulo);
        AbstractCLItau.checkCodigoDaCarteira(titulo);
        if (CARTEIRAS_ESPECIAIS.contains(titulo.getContaBancaria().getCarteira().getCodigo())) {
            return new CLItauComCarteirasEspeciais(titulo);
        }
        return new CLItauPadrao(titulo);
    }

    protected Integer calculeDigitoVerificador(String campo) {
        int restoDivisao = Modulo.calculeMod10(campo, 1, 2);
        int digito = Modulo.MOD10 - restoDivisao;
        if (digito > 9) {
            digito = 0;
        }
        return new Integer(digito);
    }

    static {
        CARTEIRAS_ESPECIAIS.add(106);
        CARTEIRAS_ESPECIAIS.add(107);
        CARTEIRAS_ESPECIAIS.add(122);
        CARTEIRAS_ESPECIAIS.add(142);
        CARTEIRAS_ESPECIAIS.add(143);
        CARTEIRAS_ESPECIAIS.add(195);
        CARTEIRAS_ESPECIAIS.add(196);
        CARTEIRAS_ESPECIAIS.add(198);
    }
}

