/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCampoLivre;
import org.jrimum.bopepo.campolivre.CLUnibancoCobrancaNaoRegistrada;
import org.jrimum.bopepo.campolivre.CLUnibancoCobrancaRegistrada;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.vallia.Modulo;

abstract class AbstractCLUnibanco
extends AbstractCampoLivre {
    private static final long serialVersionUID = -6169577742706045367L;

    protected AbstractCLUnibanco(Integer fieldsLength) {
        super(fieldsLength);
    }

    protected static CampoLivre create(Titulo titulo) throws NotSupportedCampoLivreException {
        AbstractCLUnibanco.checkCarteiraNotNull(titulo);
        AbstractCLUnibanco.checkRegistroDaCarteiraNotNull(titulo);
        switch (titulo.getContaBancaria().getCarteira().getTipoCobranca()) {
            case SEM_REGISTRO: {
                return new CLUnibancoCobrancaNaoRegistrada(titulo);
            }
            case COM_REGISTRO: {
                return new CLUnibancoCobrancaRegistrada(titulo);
            }
        }
        return null;
    }

    String calculeDigitoEmModulo11(String numero) {
        Object dv = "";
        int soma = Modulo.calculeSomaSequencialMod11(numero, 2, 9);
        int resto = (soma *= 10) % 11;
        dv = resto == 10 || resto == 0 ? "0" : "" + resto;
        return dv;
    }
}

