/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jrimum.bopepo.BancosSuportados;
import org.jrimum.bopepo.campolivre.AbstractCLBancoCitibank;
import org.jrimum.bopepo.campolivre.AbstractCLBancoDaycoval;
import org.jrimum.bopepo.campolivre.AbstractCLBancoDeBrasilia;
import org.jrimum.bopepo.campolivre.AbstractCLBancoDoBrasil;
import org.jrimum.bopepo.campolivre.AbstractCLBancoDoNordesteDoBrasil;
import org.jrimum.bopepo.campolivre.AbstractCLBancoIntermedium;
import org.jrimum.bopepo.campolivre.AbstractCLBancoReal;
import org.jrimum.bopepo.campolivre.AbstractCLBancoRural;
import org.jrimum.bopepo.campolivre.AbstractCLBancoSafra;
import org.jrimum.bopepo.campolivre.AbstractCLBancoob;
import org.jrimum.bopepo.campolivre.AbstractCLBanestes;
import org.jrimum.bopepo.campolivre.AbstractCLBanrisul;
import org.jrimum.bopepo.campolivre.AbstractCLBradesco;
import org.jrimum.bopepo.campolivre.AbstractCLCaixaEconomicaFederal;
import org.jrimum.bopepo.campolivre.AbstractCLCecred;
import org.jrimum.bopepo.campolivre.AbstractCLHSBC;
import org.jrimum.bopepo.campolivre.AbstractCLItau;
import org.jrimum.bopepo.campolivre.AbstractCLMercantilDoBrasil;
import org.jrimum.bopepo.campolivre.AbstractCLSantander;
import org.jrimum.bopepo.campolivre.AbstractCLSicredi;
import org.jrimum.bopepo.campolivre.AbstractCLUnibanco;
import org.jrimum.bopepo.campolivre.AbstractCLUnicred;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.campolivre.CampoLivreException;
import org.jrimum.bopepo.campolivre.NotSupportedBancoException;
import org.jrimum.bopepo.campolivre.NotSupportedCampoLivreException;
import org.jrimum.domkee.banco.Banco;
import org.jrimum.domkee.banco.ParametroBancario;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.BlockOfFields;
import org.jrimum.texgit.IFixedField;
import org.jrimum.utilix.Objects;
import org.jrimum.utilix.Strings;

abstract class AbstractCampoLivre
extends BlockOfFields
implements CampoLivre {
    private static final long serialVersionUID = 4605730904122445595L;
    protected static Logger log = Logger.getLogger(Objects.class);
    static final int NN7 = 7;
    static final int NN8 = 8;
    static final int NN9 = 9;
    static final int NN10 = 10;
    static final int NN11 = 11;
    static final int NN14 = 14;
    static final int NN15 = 15;
    static final int NN17 = 17;

    private AbstractCampoLivre(Integer fieldsLength, Integer stringLength) {
        super(null, null);
    }

    protected AbstractCampoLivre(Integer fieldsLength) {
        this.setLength(CampoLivre.STRING_LENGTH);
        this.setSize(fieldsLength);
    }

    protected static CampoLivre create(Titulo titulo) throws NotSupportedBancoException, NotSupportedCampoLivreException, CampoLivreException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Instanciando Campo livre");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("titulo instance : " + titulo));
        }
        try {
            AbstractCampoLivre.checkTituloNotNull(titulo);
            AbstractCampoLivre.checkContaBancariaNotNull(titulo);
            AbstractCampoLivre.checkBancoNotNull(titulo);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Campo Livre do Banco: %s", titulo.getContaBancaria().getBanco().getNome()));
            }
            if (BancosSuportados.isSuportado(titulo.getContaBancaria().getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado())) {
                BancosSuportados banco = BancosSuportados.suportados.get(titulo.getContaBancaria().getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado());
                switch (banco) {
                    case BANCO_BRADESCO: {
                        return AbstractCLBradesco.create(titulo);
                    }
                    case BANCO_DO_BRASIL: {
                        return AbstractCLBancoDoBrasil.create(titulo);
                    }
                    case BANCO_DO_NORDESTE_DO_BRASIL: {
                        return AbstractCLBancoDoNordesteDoBrasil.create(titulo);
                    }
                    case BANCO_ABN_AMRO_REAL: {
                        return AbstractCLBancoReal.create(titulo);
                    }
                    case CAIXA_ECONOMICA_FEDERAL: {
                        return AbstractCLCaixaEconomicaFederal.create(titulo);
                    }
                    case HSBC: {
                        return AbstractCLHSBC.create(titulo);
                    }
                    case UNIBANCO: {
                        return AbstractCLUnibanco.create(titulo);
                    }
                    case BANCO_ITAU: {
                        return AbstractCLItau.create(titulo);
                    }
                    case BANCO_SAFRA: {
                        return AbstractCLBancoSafra.create(titulo);
                    }
                    case BANCO_DO_ESTADO_DO_RIO_GRANDE_DO_SUL: {
                        return AbstractCLBanrisul.create(titulo);
                    }
                    case MERCANTIL_DO_BRASIL: {
                        return AbstractCLMercantilDoBrasil.create(titulo);
                    }
                    case BANCO_DO_ESTADO_DO_ESPIRITO_SANTO: {
                        return AbstractCLBanestes.create(titulo);
                    }
                    case BANCO_RURAL: {
                        return AbstractCLBancoRural.create(titulo);
                    }
                    case BANCO_SANTANDER: {
                        return AbstractCLSantander.create(titulo);
                    }
                    case BANCO_INTEMEDIUM: {
                        return AbstractCLBancoIntermedium.create(titulo);
                    }
                    case BANCO_SICREDI: {
                        return AbstractCLSicredi.create(titulo);
                    }
                    case BANCOOB: {
                        return AbstractCLBancoob.create(titulo);
                    }
                    case CITIBANK: {
                        return AbstractCLBancoCitibank.create(titulo);
                    }
                    case BANCO_DE_BRASILIA: {
                        return AbstractCLBancoDeBrasilia.create(titulo);
                    }
                    case CECRED: {
                        return AbstractCLCecred.create(titulo);
                    }
                    case UNICRED: {
                        return AbstractCLUnicred.create(titulo);
                    }
                    case BANCO_DAYCOVAL: {
                        return AbstractCLBancoDaycoval.create(titulo);
                    }
                }
                throw new NotSupportedCampoLivreException("N\u00e3o h\u00e1 implementa\u00e7\u00f5es de campo livre para o banco " + titulo.getContaBancaria().getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado() + " compat\u00edveis com as caracter\u00edticas do t\u00edtulo informado.");
            }
            throw new NotSupportedBancoException();
        }
        catch (CampoLivreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CampoLivreException(e);
        }
    }

    protected final CampoLivre build(Titulo titulo) {
        this.checkValues(titulo);
        this.addFields(titulo);
        return this;
    }

    protected abstract void checkValues(Titulo var1);

    protected abstract void addFields(Titulo var1);

    protected final String writeFields() {
        StringBuilder campoLivreAtual = new StringBuilder();
        for (IFixedField f : this) {
            campoLivreAtual.append((String)f.write());
        }
        return campoLivreAtual.toString();
    }

    private static void checkTituloNotNull(Titulo titulo) {
        Objects.checkNotNull(titulo, "T\u00edtulo n\u00e3o pode ser nulo!");
    }

    private static void checkContaBancariaNotNull(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria(), "Conta banc\u00e1ria do t\u00edtulo n\u00e3o pode ser nula!");
    }

    private static void checkBancoNotNull(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getBanco(), "Banco da conta banc\u00e1ria do t\u00edtulo n\u00e3o pode ser nulo!");
        boolean expression = Banco.isCodigoDeCompensacaoOK(titulo.getContaBancaria().getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado());
        Objects.checkArgument(expression, String.format("C\u00f3digo de compensa\u00e7\u00e3o [%s] inv\u00e1lido!", titulo.getContaBancaria().getBanco().getCodigoDeCompensacaoBACEN().getCodigoFormatado()));
    }

    protected static final void checkCarteiraNotNull(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getCarteira(), "Carteira da conta banc\u00e1ria do t\u00edtulo n\u00e3o pode ser nula!");
    }

    protected static final void checkRegistroDaCarteiraNotNull(Titulo titulo) {
        Objects.checkNotNull((Object)titulo.getContaBancaria().getCarteira().getTipoCobranca(), "Tipo de cobran\u00e7a (COM ou SEM registro) da carteira n\u00e3o pode ser nulo!");
    }

    protected static final void checkCodigoDaCarteira(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getCarteira().getCodigo(), "C\u00f3digo da carteira n\u00e3o pode ser nulo!");
        boolean expression = titulo.getContaBancaria().getCarteira().getCodigo() > 0;
        Objects.checkArgument(expression, String.format("C\u00f3digo da carteira deve ser um n\u00famero inteiro natural positivo e n\u00e3o [%s].", titulo.getContaBancaria().getCarteira().getCodigo()));
    }

    protected static final void checkCodigoDaCarteiraMenorOuIgualQue(Titulo titulo, int limite) {
        boolean expression = titulo.getContaBancaria().getCarteira().getCodigo() <= limite;
        Objects.checkArgument(expression, String.format("C\u00f3digo [%s] da carteira deve ser um n\u00famero menor que ou igual a [%s].", titulo.getContaBancaria().getCarteira().getCodigo(), limite));
    }

    protected static final void checkAgenciaNotNull(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getAgencia(), "Ag\u00eancia banc\u00e1ria do t\u00edtulo n\u00e3o pode ser nula!");
    }

    protected static final void checkCodigoDaAgencia(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getAgencia().getCodigo(), "C\u00f3digo da ag\u00eancia banc\u00e1ria n\u00e3o pode ser nulo!");
        boolean expression = titulo.getContaBancaria().getAgencia().getCodigo() > 0;
        Objects.checkArgument(expression, String.format("C\u00f3digo da ag\u00eancia banc\u00e1ria deve ser um n\u00famero inteiro natural positivo e n\u00e3o [%s].", titulo.getContaBancaria().getAgencia().getCodigo()));
    }

    protected static final void checkCodigoDaAgenciaMenorOuIgualQue(Titulo titulo, int limite) {
        boolean expression = titulo.getContaBancaria().getAgencia().getCodigo() <= limite;
        Objects.checkArgument(expression, String.format("C\u00f3digo [%s] da ag\u00eancia deve ser um n\u00famero menor que ou igual a [%s].", titulo.getContaBancaria().getAgencia().getCodigo(), limite));
    }

    protected static final void checkDigitoDoCodigoDaAgencia(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getAgencia().getDigitoVerificador(), "D\u00edgito verificador da ag\u00eancia banc\u00e1ria n\u00e3o pode ser nulo!");
        Strings.checkNotBlank(titulo.getContaBancaria().getAgencia().getDigitoVerificador(), String.format("D\u00edgito verificador [\"%s\"] da ag\u00eancia banc\u00e1ria n\u00e3o pode ser vazio!", titulo.getContaBancaria().getAgencia().getDigitoVerificador()));
        Strings.checkNotNumeric(titulo.getContaBancaria().getAgencia().getDigitoVerificador(), String.format("Nesse contexto o d\u00edgito verificador [\"%s\"] da ag\u00eancia banc\u00e1ria deve ser num\u00e9rico!", titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta()));
    }

    protected static final void checkNumeroDaContaNotNull(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getNumeroDaConta(), "N\u00famero da conta banc\u00e1ria do t\u00edtulo n\u00e3o pode ser nulo!");
    }

    protected static final void checkCodigoDoNumeroDaConta(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), "C\u00f3digo do n\u00famero da conta banc\u00e1ria n\u00e3o pode ser nulo!");
        boolean expression = titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta() > 0;
        Objects.checkArgument(expression, String.format("C\u00f3digo do n\u00famero da conta banc\u00e1ria deve ser um n\u00famero inteiro natural positivo e n\u00e3o [%s].", titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta()));
    }

    protected static final void checkCodigoDoNumeroDaContaMenorOuIgualQue(Titulo titulo, int limite) {
        boolean expression = titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta() <= limite;
        Objects.checkArgument(expression, String.format("C\u00f3digo [%s] do n\u00famero da conta deve ser um n\u00famero menor que ou igual a [%s].", titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), limite));
    }

    protected static final void checkDigitoDoCodigoDoNumeroDaConta(Titulo titulo) {
        Objects.checkNotNull(titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta(), "D\u00edgito verificador do n\u00famero da conta banc\u00e1ria n\u00e3o pode ser nulo!");
        Strings.checkNotBlank(titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta(), String.format("D\u00edgito verificador [\"%s\"] do n\u00famero da conta banc\u00e1ria n\u00e3o pode ser vazio!", titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta()));
        Strings.checkNotNumeric(titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta(), String.format("Nesse contexto o d\u00edgito verificador [\"%s\"] do n\u00famero da conta deve ser num\u00e9rico!", titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta()));
    }

    protected static final void checkNossoNumero(Titulo titulo) {
        Objects.checkNotNull(titulo.getNossoNumero(), "Nosso n\u00famero do t\u00edtulo n\u00e3o pode ser nulo!");
        Strings.checkNotBlank(titulo.getNossoNumero(), String.format("Nosso n\u00famero [\"%s\"] do t\u00edtulo n\u00e3o pode ser vazio!", titulo.getNossoNumero()));
        Strings.checkNotNumeric(titulo.getNossoNumero(), String.format("Nosso n\u00famero [\"%s\"] do t\u00edtulo deve conter somente d\u00edgitos num\u00e9ricos!", titulo.getNossoNumero()));
    }

    protected static final void checkTamanhoDoNossoNumero(Titulo titulo, int length) {
        AbstractCampoLivre.checkTamanhoNossoNumero(titulo, length, String.format("Tamanho [%s] do nosso n\u00famero [\"%s\"] diferente do esperado [%s]!", StringUtils.length((CharSequence)titulo.getNossoNumero()), titulo.getNossoNumero(), length));
    }

    protected static final void checkTamanhoNossoNumero(Titulo titulo, int length, String msg) {
        Objects.checkArgument(titulo.getNossoNumero().length() == length, msg);
    }

    protected static final void checkDigitoDoNossoNumero(Titulo titulo) {
        Objects.checkNotNull(titulo.getDigitoDoNossoNumero(), "D\u00edgito verificador do nosso n\u00famero do t\u00edtulo n\u00e3o pode ser nulo!");
        Strings.checkNotBlank(titulo.getDigitoDoNossoNumero(), String.format("D\u00edgito verificador [\"%s\"] do nosso n\u00famero do t\u00edtulo n\u00e3o pode ser vazio!", titulo.getDigitoDoNossoNumero()));
        Strings.checkNotNumeric(titulo.getDigitoDoNossoNumero(), String.format("Nesse contexto o d\u00edgito verificador [\"%s\"] do nosso n\u00famero deve ser um n\u00famero inteiro positivo!", titulo.getDigitoDoNossoNumero()));
    }

    protected static final void checkTamanhoDigitoDoNossoNumero(Titulo titulo, int length) {
        AbstractCampoLivre.checkTamanhoDigitoDoNossoNumero(titulo, length, String.format("Tamanho [%s] do d\u00edgito do nosso n\u00famero [\"%s\"] diferente do esperado [%s]!", StringUtils.length((CharSequence)titulo.getDigitoDoNossoNumero()), titulo.getDigitoDoNossoNumero(), length));
    }

    protected static final void checkTamanhoDigitoDoNossoNumero(Titulo titulo, int length, String msg) {
        Objects.checkArgument(titulo.getDigitoDoNossoNumero().length() == length, msg);
    }

    protected static final void checkValor(Titulo titulo) {
        Objects.checkNotNull(titulo.getValor(), "Valor do t\u00edtulo n\u00e3o pode ser nulo!");
        Objects.checkArgument(titulo.getValor().compareTo(BigDecimal.ZERO) >= 0, String.format("O valor do t\u00edtulo deve ser um n\u00famero positivo ou zero e n\u00e3o [%s].", titulo.getValor()));
    }

    protected static final void checkParametroBancario(Titulo titulo, ParametroBancario<?> param) {
        Objects.checkNotNull(titulo.getParametrosBancarios(), String.format("O par\u00e2metro banc\u00e1rio [\"%s\"] \u00e9 necess\u00e1rio! [titulo.getParametrosBancarios() == null]", param));
        Objects.checkArgument(titulo.getParametrosBancarios().contemComNome(param), String.format("Par\u00e2metro banc\u00e1rio [\"%s\"] n\u00e3o encontrado!", param));
        Objects.checkNotNull(titulo.getParametrosBancarios().getValor(param), String.format("Par\u00e2metro banc\u00e1rio [\"%s\"] n\u00e3o cont\u00e9m valor!", param));
    }

    protected static final void checkParametroBancarioMenorOuIgualQue(Titulo titulo, ParametroBancario<?> param, int limite) {
        AbstractCampoLivre.checkParametroBancario(titulo, param);
        int valor = ((Number)titulo.getParametrosBancarios().getValor(param)).intValue();
        boolean expression = valor <= limite;
        Objects.checkArgument(expression, String.format("Par\u00e2metro [%s] com valor [%s] deve ser um n\u00famero menor que ou igual a [%s].", param, valor, limite));
    }

    public String toString() {
        return Objects.toString(this);
    }
}

