/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoDaycoval;
import org.jrimum.bopepo.parametro.ParametroBancoDaycoval;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;

class CLBancoDaycoval
extends AbstractCLBancoDaycoval {
    private static final long serialVersionUID = 858563493013156459L;
    private static final Integer FIELDS_LENGTH = 4;
    private static final Integer AGENCIA_LENGTH = 4;
    private static final Integer CARTEIRA_LENGTH = 3;
    private static final Integer NOSSO_NUMERO_LENGTH = 11;
    private static final Integer OPERACAO_LENGTH = 7;

    protected CLBancoDaycoval() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void addFields(Titulo titulo) {
        StringBuilder nossoNumero = new StringBuilder(titulo.getNossoNumero());
        nossoNumero.append(titulo.getDigitoDoNossoNumero());
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), AGENCIA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getCarteira().getCodigo(), CARTEIRA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>((Integer)titulo.getParametrosBancarios().getValor(ParametroBancoDaycoval.OPERACAO), OPERACAO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(nossoNumero.toString(), NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLBancoDaycoval.checkAgenciaNotNull(titulo);
        CLBancoDaycoval.checkCodigoDaAgencia(titulo);
        CLBancoDaycoval.checkCodigoDaAgenciaMenorOuIgualQue(titulo, 9999);
        CLBancoDaycoval.checkCarteiraNotNull(titulo);
        CLBancoDaycoval.checkCodigoDaCarteira(titulo);
        CLBancoDaycoval.checkCodigoDaCarteiraMenorOuIgualQue(titulo, 999);
        CLBancoDaycoval.checkParametroBancario(titulo, ParametroBancoDaycoval.OPERACAO);
        CLBancoDaycoval.checkParametroBancarioMenorOuIgualQue(titulo, ParametroBancoDaycoval.OPERACAO, 9999999);
        CLBancoDaycoval.checkNossoNumero(titulo);
        CLBancoDaycoval.checkTamanhoDoNossoNumero(titulo, 10);
        CLBancoDaycoval.checkDigitoDoNossoNumero(titulo);
        CLBancoDaycoval.checkTamanhoDigitoDoNossoNumero(titulo, 1);
    }
}

