/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoDeBrasilia;
import org.jrimum.bopepo.parametro.ParametroBancoDeBrasilia;
import org.jrimum.domkee.banco.ParametrosBancariosMap;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Objects;
import org.jrimum.vallia.Modulo;

public class CLBancoDeBrasilia
extends AbstractCLBancoDeBrasilia {
    private static final long serialVersionUID = -6099168685425835517L;
    private static final Integer FIELDS_LENGTH = 8;
    private static final Integer CAMPO_ZERADO_LENGTH = 3;
    private static final String CAMPO_ZERADO_VALUE = "000";
    private static final Integer AGENCIA_LENGTH = 3;
    private static final Integer CONTA_LENGTH = 7;
    private static final Integer NOSSO_NUMERO_LENGTH = 6;
    private static final Integer CARTEIRA_LENGTH = 1;
    private static final Integer DIGITO_CHAVE_ASBACE_LENGTH = 1;
    private static final Integer BANCO_LENGTH = 3;
    private static final Integer CARTEIRA_SEM_REGISTRO = 1;
    private static final Integer CARTEIRA_COM_REGISTRO = 2;
    private Integer digitoVerificador1DaChaveASBACE;
    private Integer digitoVerificador2DaChaveASBACE;

    protected CLBancoDeBrasilia() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLBancoDeBrasilia.checkAgenciaNotNull(titulo);
        CLBancoDeBrasilia.checkCodigoDaAgencia(titulo);
        CLBancoDeBrasilia.checkCodigoDaAgenciaMenorOuIgualQue(titulo, 999);
        CLBancoDeBrasilia.checkNumeroDaContaNotNull(titulo);
        CLBancoDeBrasilia.checkCodigoDoNumeroDaConta(titulo);
        CLBancoDeBrasilia.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 9999999);
        CLBancoDeBrasilia.checkNossoNumero(titulo);
        CLBancoDeBrasilia.checkTamanhoDoNossoNumero(titulo, 6);
        CLBancoDeBrasilia.checkCarteiraNotNull(titulo);
        CLBancoDeBrasilia.checkCodigoDaCarteira(titulo);
        this.checkCarteiraComOuSemRegistro(titulo);
    }

    @Override
    protected void addFields(Titulo titulo) {
        this.add(new FixedField<String>(CAMPO_ZERADO_VALUE, CAMPO_ZERADO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), AGENCIA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getCarteira().getCodigo(), CARTEIRA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getBanco().getCodigoDeCompensacaoBACEN().getCodigo(), BANCO_LENGTH, Fillers.ZERO_LEFT));
        this.calculeDigitosNecessariosDaChaveASBACE();
        this.add(new FixedField<Integer>(this.digitoVerificador1DaChaveASBACE, DIGITO_CHAVE_ASBACE_LENGTH));
        this.add(new FixedField<Integer>(this.digitoVerificador2DaChaveASBACE, DIGITO_CHAVE_ASBACE_LENGTH));
        this.disponibilizeDigitosDaChaveAsbaceNeste(titulo);
    }

    private void calculeDigitosNecessariosDaChaveASBACE() {
        this.calculeChaveAsbaceDigito1();
        this.calculeChaveAsbaceDigito2();
    }

    private void calculeChaveAsbaceDigito1() {
        String chaveAasbace = this.writeFields();
        int dig = Modulo.calculeMod10(chaveAasbace, 1, 2);
        this.digitoVerificador1DaChaveASBACE = dig == 0 ? Integer.valueOf(dig) : Integer.valueOf(10 - dig);
    }

    private void calculeChaveAsbaceDigito2() {
        String chaveAasbaceComDv1 = this.writeFields() + this.digitoVerificador1DaChaveASBACE;
        int digito2 = Modulo.calculeMod11(chaveAasbaceComDv1, 2, 7);
        if (digito2 == 0) {
            this.digitoVerificador2DaChaveASBACE = digito2;
        } else if (digito2 != 1) {
            this.digitoVerificador2DaChaveASBACE = 11 - digito2;
        } else {
            int digito1Recalculado = this.digitoVerificador1DaChaveASBACE + 1;
            this.digitoVerificador1DaChaveASBACE = digito1Recalculado == 10 ? 0 : digito1Recalculado;
            this.calculeChaveAsbaceDigito2();
        }
    }

    private void disponibilizeDigitosDaChaveAsbaceNeste(Titulo titulo) {
        ParametrosBancariosMap parametrosBancarios = titulo.getParametrosBancarios();
        if (parametrosBancarios == null) {
            parametrosBancarios = new ParametrosBancariosMap();
        }
        parametrosBancarios.adicione(ParametroBancoDeBrasilia.CHAVE_ASBACE_DIGITO1, this.digitoVerificador1DaChaveASBACE);
        parametrosBancarios.adicione(ParametroBancoDeBrasilia.CHAVE_ASBACE_DIGITO2, this.digitoVerificador2DaChaveASBACE);
        titulo.setParametrosBancarios(parametrosBancarios);
    }

    private void checkCarteiraComOuSemRegistro(Titulo titulo) {
        Integer codigoCarteira = titulo.getContaBancaria().getCarteira().getCodigo();
        boolean carteiraValida = codigoCarteira.equals(CARTEIRA_SEM_REGISTRO) || codigoCarteira.equals(CARTEIRA_COM_REGISTRO);
        Objects.checkArgument(carteiraValida, String.format("C\u00f3digo da carteira deve ser \"1-Sem registro impress\u00e3o local\" ou  \"2-Com registro impress\u00e3o local\" e n\u00e3o [%s].", titulo.getContaBancaria().getCarteira().getCodigo()));
    }
}

