/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoDoBrasil;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;

class CLBancoDoBrasilNN17Convenio7
extends AbstractCLBancoDoBrasil {
    private static final long serialVersionUID = 2347714390743602306L;
    protected static final Integer FIELDS_LENGTH = 3;
    protected static final Integer CONSTANT_LENGTH = 6;
    protected static final Integer CONSTANT_VALUE = 0;
    private static final FixedField<Integer> CONSTANT_FIELD = new FixedField<Integer>(CONSTANT_VALUE, CONSTANT_LENGTH, Fillers.ZERO_LEFT);
    protected static final Integer NOSSO_NUMERO_LENGTH = 17;
    protected static final Integer CARTEIRA_LENGTH = 2;

    protected CLBancoDoBrasilNN17Convenio7() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLBancoDoBrasilNN17Convenio7.checkNossoNumero(titulo);
        CLBancoDoBrasilNN17Convenio7.checkTamanhoDoNossoNumero(titulo, 17);
        CLBancoDoBrasilNN17Convenio7.checkCarteiraNotNull(titulo);
        CLBancoDoBrasilNN17Convenio7.checkCodigoDaCarteira(titulo);
        CLBancoDoBrasilNN17Convenio7.checkCodigoDaCarteiraMenorOuIgualQue(titulo, 99);
    }

    @Override
    protected void addFields(Titulo titulo) {
        this.add(CONSTANT_FIELD);
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getCarteira().getCodigo(), CARTEIRA_LENGTH, Fillers.ZERO_LEFT));
    }
}

