/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoDoNordesteDoBrasil;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;

class CLBancoDoNordesteDoBrasil
extends AbstractCLBancoDoNordesteDoBrasil {
    private static final long serialVersionUID = 5203223333877548162L;
    private static final Integer FIELDS_LENGTH = 7;
    private static final Integer AGENCIA_LENGTH = 4;
    private static final Integer CONTA_LENGTH = 7;
    private static final Integer DIGITO_CONTA_LENGTH = 1;
    private static final Integer NOSSO_NUMERO_LENGTH = 7;
    private static final Integer DIGITO_NOSSO_NUMERO_LENGTH = 1;
    private static final Integer CARTEIRA_LENGTH = 2;
    private static final Integer CAMPO_ZERADO_LENGTH = 3;
    protected static final Integer CAMPO_ZERADO_VALUE = 0;

    protected CLBancoDoNordesteDoBrasil() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLBancoDoNordesteDoBrasil.checkAgenciaNotNull(titulo);
        CLBancoDoNordesteDoBrasil.checkCodigoDaAgencia(titulo);
        CLBancoDoNordesteDoBrasil.checkCodigoDaAgenciaMenorOuIgualQue(titulo, 9999);
        CLBancoDoNordesteDoBrasil.checkNumeroDaContaNotNull(titulo);
        CLBancoDoNordesteDoBrasil.checkCodigoDoNumeroDaConta(titulo);
        CLBancoDoNordesteDoBrasil.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 9999999);
        CLBancoDoNordesteDoBrasil.checkDigitoDoCodigoDoNumeroDaConta(titulo);
        CLBancoDoNordesteDoBrasil.checkNossoNumero(titulo);
        CLBancoDoNordesteDoBrasil.checkDigitoDoNossoNumero(titulo);
        CLBancoDoNordesteDoBrasil.checkCarteiraNotNull(titulo);
        CLBancoDoNordesteDoBrasil.checkCodigoDaCarteira(titulo);
        CLBancoDoNordesteDoBrasil.checkCodigoDaCarteiraMenorOuIgualQue(titulo, 99);
    }

    @Override
    protected void addFields(Titulo titulo) {
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), AGENCIA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta(), DIGITO_CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getDigitoDoNossoNumero(), DIGITO_NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getCarteira().getCodigo(), CARTEIRA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(CAMPO_ZERADO_VALUE, CAMPO_ZERADO_LENGTH, Fillers.ZERO_LEFT));
    }
}

