/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoReal;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Strings;
import org.jrimum.vallia.Modulo;
import org.jrimum.vallia.TipoDeModulo;

class CLBancoReal
extends AbstractCLBancoReal {
    private static final long serialVersionUID = -5294809022535972391L;
    private static final Modulo modulo10 = new Modulo(TipoDeModulo.MODULO10);
    private static final Integer FIELDS_LENGTH = 4;

    CLBancoReal(Titulo titulo) {
        super(FIELDS_LENGTH);
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), (Integer)4, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), (Integer)7, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(this.calculeDigitoDaPosicao31(titulo.getNossoNumero(), titulo.getContaBancaria().getAgencia().getCodigo(), titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta()), (Integer)1, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(Strings.eliminateSymbols(titulo.getNossoNumero()), (Integer)13, Fillers.ZERO_LEFT));
    }

    private String calculeDigitoDaPosicao31(String nossoNumero, Integer agencia, Integer contaCorrente) {
        StringBuilder formula = new StringBuilder();
        Object dV = null;
        formula.append(Fillers.ZERO_LEFT.fill(nossoNumero, 13));
        formula.append(Fillers.ZERO_LEFT.fill(agencia, 4));
        formula.append(Fillers.ZERO_LEFT.fill(contaCorrente, 7));
        int restoDivisao = modulo10.calcule(formula.toString());
        int restoSubtracao = 10 - restoDivisao;
        dV = restoSubtracao == 10 ? "0" : "" + restoSubtracao;
        return dV;
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

