/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoSafra;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;

class CLBancoSafraCobrancaNaoRegistrada
extends AbstractCLBancoSafra {
    private static final long serialVersionUID = -6573340701469029151L;
    protected static final Integer FIELDS_LENGTH = 5;
    private static final Integer CONTA_LENGTH = 5;
    private static final Integer CONTA_DIGITO_LENGTH = 1;
    private static final Integer NOSSO_NUMERO_LENGTH = 17;

    protected CLBancoSafraCobrancaNaoRegistrada() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLBancoSafraCobrancaNaoRegistrada.checkNumeroDaContaNotNull(titulo);
        CLBancoSafraCobrancaNaoRegistrada.checkCodigoDoNumeroDaConta(titulo);
        CLBancoSafraCobrancaNaoRegistrada.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 999999);
        CLBancoSafraCobrancaNaoRegistrada.checkDigitoDoCodigoDoNumeroDaConta(titulo);
        CLBancoSafraCobrancaNaoRegistrada.checkNossoNumero(titulo);
        CLBancoSafraCobrancaNaoRegistrada.checkTamanhoDoNossoNumero(titulo, 17);
    }

    @Override
    protected void addFields(Titulo titulo) {
        this.add(SISTEMA_CONSTANT_FIELD);
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta(), CONTA_DIGITO_LENGTH));
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH));
        this.add(new FixedField<Integer>(Integer.valueOf(AbstractCLBancoSafra.TipoDeCobranca.EXPRESS_BOLETO_EMITIDO_PELO_CLIENTE.codigo()), TIPO_COBRANCA_FIELD_LENGTH));
    }
}

