/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoSafra;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;

class CLBancoSafraCobrancaRegistrada
extends AbstractCLBancoSafra {
    private static final long serialVersionUID = -4532989921797507161L;
    protected static final Integer FIELDS_LENGTH = 7;
    private static final Integer AGENCIA_LENGTH = 4;
    private static final Integer AGENCIA_DIGITO_LENGTH = 1;
    private static final Integer CONTA_LENGTH = 8;
    private static final Integer CONTA_DIGITO_LENGTH = 1;
    private static final Integer NOSSO_NUMERO_LENGTH = 9;

    protected CLBancoSafraCobrancaRegistrada() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLBancoSafraCobrancaRegistrada.checkAgenciaNotNull(titulo);
        CLBancoSafraCobrancaRegistrada.checkCodigoDaAgencia(titulo);
        CLBancoSafraCobrancaRegistrada.checkCodigoDaAgenciaMenorOuIgualQue(titulo, 9999);
        CLBancoSafraCobrancaRegistrada.checkDigitoDoCodigoDaAgencia(titulo);
        CLBancoSafraCobrancaRegistrada.checkNumeroDaContaNotNull(titulo);
        CLBancoSafraCobrancaRegistrada.checkCodigoDoNumeroDaConta(titulo);
        CLBancoSafraCobrancaRegistrada.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 999999);
        CLBancoSafraCobrancaRegistrada.checkDigitoDoCodigoDoNumeroDaConta(titulo);
        CLBancoSafraCobrancaRegistrada.checkNossoNumero(titulo);
        CLBancoSafraCobrancaRegistrada.checkTamanhoDoNossoNumero(titulo, 9);
    }

    @Override
    protected void addFields(Titulo titulo) {
        this.add(SISTEMA_CONSTANT_FIELD);
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), AGENCIA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getContaBancaria().getAgencia().getDigitoVerificador(), AGENCIA_DIGITO_LENGTH));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta(), CONTA_DIGITO_LENGTH));
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH));
        this.add(new FixedField<Integer>(Integer.valueOf(AbstractCLBancoSafra.TipoDeCobranca.DIRETA_BOLETO_EMITIDO_PELO_CLIENTE.codigo()), TIPO_COBRANCA_FIELD_LENGTH));
    }
}

