/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLSantander;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.parametro.ParametroBancoSantander;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

class CLBancoSantander
extends AbstractCLSantander
implements CampoLivre {
    private static final long serialVersionUID = -412221524249334574L;
    private static final Integer FIELDS_LENGTH = 6;
    private static final Integer CONSTANTE = 9;
    private static final int CARTEIRA_RAPIDA_COM_REGISTRO = 101;
    private static final int CARTEIRA_RAPIDA_SEM_REGISTRO = 201;
    private static final int CARTEIRA_SIMPLES_SEM_REGISTRO = 102;
    private static final int COBRANCA_SIMPLES_ELETRONICA_COM_REGISTRO = 104;

    CLBancoSantander(Titulo titulo) {
        super(FIELDS_LENGTH);
        ContaBancaria conta = titulo.getContaBancaria();
        StringBuilder nossoNumero = new StringBuilder(titulo.getNossoNumero());
        nossoNumero.append(titulo.getDigitoDoNossoNumero());
        this.add(new FixedField<Integer>(CONSTANTE, (Integer)1));
        this.add(new FixedField<Integer>(conta.getNumeroDaConta().getCodigoDaConta(), (Integer)6, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(conta.getNumeroDaConta().getDigitoDaConta(), 1));
        this.add(new FixedField<String>(nossoNumero.toString(), (Integer)13, Fillers.ZERO_LEFT));
        if (titulo.hasParametrosBancarios() && Objects.isNotNull(titulo.getParametrosBancarios().getValor(ParametroBancoSantander.IOF_SEGURADORA))) {
            this.add(new FixedField<Integer>((Integer)titulo.getParametrosBancarios().getValor(ParametroBancoSantander.IOF_SEGURADORA), (Integer)1));
        } else {
            this.add(new FixedField<Integer>(Integer.valueOf(0), (Integer)1));
        }
        switch (conta.getCarteira().getCodigo()) {
            case 101: 
            case 102: 
            case 104: 
            case 201: {
                this.add(new FixedField<Integer>(conta.getCarteira().getCodigo(), (Integer)3, Fillers.ZERO_LEFT));
                break;
            }
            default: {
                Exceptions.throwIllegalArgumentException(String.format("CARTEIRA [%s] N\u00c3O SUPORTADA!", conta.getCarteira().getCodigo()));
            }
        }
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

