/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoob;
import org.jrimum.bopepo.parametro.ParametroBancoob;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;

public class CLBancoobCobrancaNaoRegistrada
extends AbstractCLBancoob {
    private static final long serialVersionUID = 2864939240695151533L;
    protected static final Integer FIELDS_LENGTH = 8;
    protected static final Integer CARTEIRA_LENGTH = 1;
    protected static final Integer AGENCIA_LENGTH = 4;
    protected static final Integer MODALIDADE_DE_COBRANCA_LENGTH = 2;
    protected static final Integer COBRANCA_SIMPLES = 1;
    private static final Integer NOSSO_NUMERO_LENGTH = 7;
    private static final Integer DV_NOSSO_NUMERO_LENGTH = 1;
    private static final Integer CONTA_LENGTH = 6;
    private static final Integer DV_CONTA_LENGTH = 1;
    private static final Integer UMA_PARCELA = 1;
    private static final Integer NUMERO_DA_PARCELA_LENGTH = 3;

    protected CLBancoobCobrancaNaoRegistrada() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLBancoobCobrancaNaoRegistrada.checkCarteiraNotNull(titulo);
        CLBancoobCobrancaNaoRegistrada.checkCodigoDaCarteira(titulo);
        CLBancoobCobrancaNaoRegistrada.checkCodigoDaCarteiraMenorOuIgualQue(titulo, 9);
        CLBancoobCobrancaNaoRegistrada.checkAgenciaNotNull(titulo);
        CLBancoobCobrancaNaoRegistrada.checkCodigoDaAgencia(titulo);
        CLBancoobCobrancaNaoRegistrada.checkCodigoDaAgenciaMenorOuIgualQue(titulo, 9999);
        CLBancoobCobrancaNaoRegistrada.checkNossoNumero(titulo);
        CLBancoobCobrancaNaoRegistrada.checkTamanhoDoNossoNumero(titulo, 7);
        CLBancoobCobrancaNaoRegistrada.checkDigitoDoNossoNumero(titulo);
        CLBancoobCobrancaNaoRegistrada.checkTamanhoDigitoDoNossoNumero(titulo, DV_NOSSO_NUMERO_LENGTH);
        CLBancoobCobrancaNaoRegistrada.checkNumeroDaContaNotNull(titulo);
        CLBancoobCobrancaNaoRegistrada.checkCodigoDoNumeroDaConta(titulo);
        CLBancoobCobrancaNaoRegistrada.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 9999999);
        CLBancoobCobrancaNaoRegistrada.checkDigitoDoCodigoDoNumeroDaConta(titulo);
        CLBancoobCobrancaNaoRegistrada.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 999999);
    }

    @Override
    protected void addFields(Titulo titulo) {
        Integer codigoDaModalidadeDeCobranca = COBRANCA_SIMPLES;
        Integer numeroDaParcela = UMA_PARCELA;
        if (titulo.hasParametrosBancarios()) {
            if (titulo.getParametrosBancarios().contemComNome(ParametroBancoob.MODALIDADE_DE_COBRANCA)) {
                CLBancoobCobrancaNaoRegistrada.checkParametroBancario(titulo, ParametroBancoob.MODALIDADE_DE_COBRANCA);
                codigoDaModalidadeDeCobranca = (Integer)titulo.getParametrosBancarios().getValor(ParametroBancoob.MODALIDADE_DE_COBRANCA);
            }
            if (titulo.getParametrosBancarios().contemComNome(ParametroBancoob.NUMERO_DA_PARCELA)) {
                CLBancoobCobrancaNaoRegistrada.checkParametroBancario(titulo, ParametroBancoob.NUMERO_DA_PARCELA);
                numeroDaParcela = (Integer)titulo.getParametrosBancarios().getValor(ParametroBancoob.NUMERO_DA_PARCELA);
            }
        }
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getCarteira().getCodigo(), CARTEIRA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), AGENCIA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(codigoDaModalidadeDeCobranca, MODALIDADE_DE_COBRANCA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getContaBancaria().getNumeroDaConta().getDigitoDaConta(), DV_CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getDigitoDoNossoNumero(), DV_NOSSO_NUMERO_LENGTH));
        this.add(new FixedField<Integer>(numeroDaParcela, NUMERO_DA_PARCELA_LENGTH, Fillers.ZERO_LEFT));
    }
}

