/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBanestes;
import org.jrimum.bopepo.campolivre.CampoLivreException;
import org.jrimum.domkee.banco.TipoDeCobranca;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;
import org.jrimum.vallia.Modulo;
import org.jrimum.vallia.TipoDeModulo;

class CLBanestes
extends AbstractCLBanestes {
    private static final long serialVersionUID = 476678476727564241L;
    private static final Integer FIELDS_LENGTH = 5;

    public CLBanestes(Titulo titulo) {
        super(FIELDS_LENGTH);
        this.add(new FixedField<Integer>(Integer.valueOf(titulo.getNossoNumero()), (Integer)8, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), (Integer)11, Fillers.ZERO_LEFT));
        Integer codigoDaCarteiraDeCobranca = titulo.getContaBancaria().getCarteira().getCodigo();
        if (Objects.exists(codigoDaCarteiraDeCobranca)) {
            this.add(new FixedField<Integer>(codigoDaCarteiraDeCobranca, (Integer)1));
        } else {
            TipoDeCobranca tipoDeCobranca = titulo.getContaBancaria().getCarteira().getTipoCobranca();
            if (tipoDeCobranca == null) {
                throw new CampoLivreException("Tipo de cobran\u00e7a da carteira n\u00e3o foi especificado!");
            }
            switch (tipoDeCobranca) {
                case SEM_REGISTRO: {
                    this.add(new FixedField<Integer>(Integer.valueOf(2), (Integer)1));
                    break;
                }
                case COM_REGISTRO: {
                    if (codigoDaCarteiraDeCobranca >= 3 && codigoDaCarteiraDeCobranca <= 7) {
                        this.add(new FixedField<Integer>(codigoDaCarteiraDeCobranca, (Integer)1));
                        break;
                    }
                    throw new CampoLivreException("C\u00f3digo da carteira de cobran\u00e7a com registro deve ser especificado com 3,4,5,6 ou 7. Valor atual = [" + codigoDaCarteiraDeCobranca + "]");
                }
                default: {
                    throw new CampoLivreException("Tipo de cobran\u00e7a [" + tipoDeCobranca + "] n\u00e3o \u00e9 suportado!");
                }
            }
        }
        this.add(new FixedField<Byte>(Byte.valueOf(titulo.getContaBancaria().getBanco().getCodigoDeCompensacaoBACEN().getCodigo().byteValue()), (Integer)3, Fillers.ZERO_LEFT));
        this.add(new FixedField<Byte>(Byte.valueOf(this.calculaDuploDV()), (Integer)2, Fillers.ZERO_LEFT));
    }

    private byte calculaDuploDV() {
        int segundoDV;
        byte primeiroDV;
        String fields = this.writeFields();
        int restoDoModulo11 = new Modulo(TipoDeModulo.MODULO11, 7, 2).calcule(fields + (primeiroDV = this.calculaPrimeiroDV(fields)));
        if (restoDoModulo11 == 0) {
            segundoDV = 0;
        } else if (restoDoModulo11 == 1) {
            primeiroDV = primeiroDV == 9 ? (byte)0 : (byte)(primeiroDV + 1);
            segundoDV = (byte)new Modulo(TipoDeModulo.MODULO11, 7, 2).calcule(fields + primeiroDV);
        } else {
            segundoDV = (byte)(11 - restoDoModulo11);
        }
        byte duploDV = Byte.parseByte(String.valueOf(primeiroDV) + String.valueOf(segundoDV));
        return duploDV;
    }

    private byte calculaPrimeiroDV(String fields) {
        byte restoDoModulo10 = (byte)new Modulo(TipoDeModulo.MODULO10).calcule(fields);
        byte primeiroDV = (byte)(restoDoModulo10 == 0 ? 0 : 10 - restoDoModulo10);
        return primeiroDV;
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

