/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBradesco;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;

class CLBradesco
extends AbstractCLBradesco {
    private static final long serialVersionUID = -1253549781074159862L;
    private static final Integer FIELDS_LENGTH = 5;
    private static final Integer AGENCIA_LENGTH = 4;
    private static final Integer CARTEIRA_LENGTH = 2;
    private static final Integer NOSSO_NUMERO_LENGTH = 11;
    private static final Integer CONTA_LENGTH = 7;
    private static final Integer CONSTANT_LENGTH = 1;
    private static final Integer CONSTANT_VALUE = 0;
    private static final FixedField<Integer> CONSTANT_FIELD = new FixedField<Integer>(CONSTANT_VALUE, CONSTANT_LENGTH);

    protected CLBradesco() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLBradesco.checkAgenciaNotNull(titulo);
        CLBradesco.checkCodigoDaAgencia(titulo);
        CLBradesco.checkCodigoDaAgenciaMenorOuIgualQue(titulo, 9999);
        CLBradesco.checkCarteiraNotNull(titulo);
        CLBradesco.checkCodigoDaCarteira(titulo);
        CLBradesco.checkCodigoDaCarteiraMenorOuIgualQue(titulo, 99);
        CLBradesco.checkNossoNumero(titulo);
        CLBradesco.checkTamanhoDoNossoNumero(titulo, 11);
        CLBradesco.checkNumeroDaContaNotNull(titulo);
        CLBradesco.checkCodigoDoNumeroDaConta(titulo);
        CLBradesco.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 9999999);
    }

    @Override
    protected void addFields(Titulo titulo) {
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), AGENCIA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getCarteira().getCodigo(), CARTEIRA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(CONSTANT_FIELD);
    }
}

