/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLCaixaEconomicaFederal;
import org.jrimum.bopepo.campolivre.CampoLivreException;
import org.jrimum.bopepo.parametro.ParametroCaixaEconomicaFederal;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

class CLCaixaEconomicaFederalSICOBNossoNumero10
extends AbstractCLCaixaEconomicaFederal {
    private static final long serialVersionUID = 5585190685525441426L;
    private static final Integer FIELDS_LENGTH = 4;

    CLCaixaEconomicaFederalSICOBNossoNumero10(Titulo titulo) {
        super(FIELDS_LENGTH);
        Objects.checkNotNull(titulo.getParametrosBancarios(), "Par\u00e2metros banc\u00e1rios necess\u00e1rios [titulo.getParametrosBancarios()==null]!");
        this.checkPadraoNossoNumero(titulo.getNossoNumero());
        this.add(new FixedField<String>(titulo.getNossoNumero(), 10));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), (Integer)4, Fillers.ZERO_LEFT));
        if (!titulo.getParametrosBancarios().contemComNome(ParametroCaixaEconomicaFederal.CODIGO_OPERACAO)) {
            throw new CampoLivreException("Par\u00e2metro banc\u00e1rio c\u00f3digo opera\u00e7\u00e3o (\"CodigoOperacao\") n\u00e3o encontrado!");
        }
        Integer cnpv = (Integer)titulo.getParametrosBancarios().getValor(ParametroCaixaEconomicaFederal.CODIGO_OPERACAO);
        Objects.checkNotNull(titulo.getParametrosBancarios(), "Par\u00e2metro banc\u00e1rio c\u00f3digo opera\u00e7\u00e3o inv\u00e1lido [CodigoOperacao==null]!");
        this.add(new FixedField<Integer>(cnpv, (Integer)3, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), (Integer)8, Fillers.ZERO_LEFT));
    }

    private void checkPadraoNossoNumero(String nn) {
        if (!(nn.startsWith("3") || nn.startsWith("9") || nn.startsWith("80") || nn.startsWith("81") || nn.startsWith("82"))) {
            Exceptions.throwIllegalArgumentException(String.format("Para a cobran\u00e7a SICOB o nosso n\u00famero [%s] deve come\u00e7ar com 3 que \u00e9 o identificador da \"carteira siples\" [3NNNNNNNNN] ou 9 que \u00e9 o identificador da \"carteira r\u00e1pida\" [9NNNNNNNNN] ou 80, 81 e 82 para \"carteira sem registro\" [82NNNNNNNN]!", nn));
        }
    }

    private void checkPadraoNossoNumeroPorCodigoDaCarteira(String nossoNumero, Integer codigoDaCarteira) {
        switch (codigoDaCarteira) {
            case 11: {
                if (nossoNumero.startsWith("3")) break;
                Exceptions.throwIllegalArgumentException(String.format("Para a cobran\u00e7a SICOB, carteira 11 (cobran\u00e7a simples), o nosso n\u00famero [%s] deve come\u00e7ar com 3!", nossoNumero));
                break;
            }
            case 12: {
                if (nossoNumero.startsWith("9")) break;
                Exceptions.throwIllegalArgumentException(String.format("Para a cobran\u00e7a SICOB, carteira 12 (cobran\u00e7a r\u00e1pida), o nosso n\u00famero [%s] deve come\u00e7ar com 9!", nossoNumero));
                break;
            }
            case 14: {
                if (nossoNumero.startsWith("80") || nossoNumero.startsWith("81") || nossoNumero.startsWith("82")) break;
                Exceptions.throwIllegalArgumentException(String.format("Para a cobran\u00e7a SICOB, carteira 14 (cobran\u00e7a sem registro), o nosso n\u00famero [%s] deve come\u00e7ar com 80, 81 ou 82!", nossoNumero));
            }
        }
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

