/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLCaixaEconomicaFederal;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Objects;

class CLCaixaEconomicaFederalSICOBNossoNumero14
extends AbstractCLCaixaEconomicaFederal {
    private static final long serialVersionUID = 4219053358562778591L;
    private static final Integer FIELDS_LENGTH = 5;
    private static final Integer CONTA_LENGTH = 5;
    private static final Integer AGENCIA_LENGTH = 4;
    protected static final Integer NOSSO_NUMERO_LENGTH = 14;
    private static final FixedField<Integer> CONSTANT_FIELD = new FixedField<Integer>(Integer.valueOf(7), (Integer)1);
    private static final Integer CARTEIRA_SEM_REGISTRO = 8;
    private static final FixedField<Integer> CARTEIRA_FIELD = new FixedField<Integer>(CARTEIRA_SEM_REGISTRO, (Integer)1);

    protected CLCaixaEconomicaFederalSICOBNossoNumero14() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkNumeroDaContaNotNull(titulo);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkCodigoDoNumeroDaConta(titulo);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkCodigoDoNumeroDaContaMenorOuIgualQue(titulo, 99999);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkAgenciaNotNull(titulo);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkCodigoDaAgencia(titulo);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkCodigoDaAgenciaMenorOuIgualQue(titulo, 9999);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkCarteiraNotNull(titulo);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkCodigoDaCarteira(titulo);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkCodigoDaCarteiraMenorOuIgualQue(titulo, 9);
        this.checkCarteiraSemRegistro(titulo);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkNossoNumero(titulo);
        CLCaixaEconomicaFederalSICOBNossoNumero14.checkTamanhoDoNossoNumero(titulo, 14);
    }

    @Override
    protected void addFields(Titulo titulo) {
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getNumeroDaConta().getCodigoDaConta(), CONTA_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getAgencia().getCodigo(), AGENCIA_LENGTH, Fillers.ZERO_LEFT));
        this.add(CARTEIRA_FIELD);
        this.add(CONSTANT_FIELD);
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
    }

    private void checkCarteiraSemRegistro(Titulo titulo) {
        Objects.checkArgument(titulo.getContaBancaria().getCarteira().getCodigo().equals(CARTEIRA_SEM_REGISTRO), String.format("Apenas a carteira de c\u00f3digo [8] \"Carteira Sem Registro Eletr\u00f4nica\" \u00e9 permitida e n\u00e3o o c\u00f3digo [%s]!", titulo.getContaBancaria().getCarteira().getCodigo()));
    }
}

