/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.bopepo.campolivre.AbstractCLCaixaEconomicaFederal;
import org.jrimum.domkee.banco.ContaBancaria;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;
import org.jrimum.utilix.Exceptions;
import org.jrimum.vallia.Modulo;

class CLCaixaEconomicaFederalSIGCB
extends AbstractCLCaixaEconomicaFederal {
    private static final long serialVersionUID = -7642075752245778160L;
    private static final Integer FIELDS_LENGTH = 8;
    private static final int COBRANCA_REGISTRADA = 1;
    private static final int COBRANCA_NAO_REGISTRADA = 2;
    private static final int EMISSAO_CEDENTE = 4;

    CLCaixaEconomicaFederalSIGCB(Titulo titulo) {
        super(FIELDS_LENGTH);
        ContaBancaria conta = titulo.getContaBancaria();
        String nossoNumero = titulo.getNossoNumero();
        Integer dVCodigoDoCedente = null;
        dVCodigoDoCedente = StringUtils.isNotBlank((CharSequence)conta.getNumeroDaConta().getDigitoDaConta()) ? Integer.valueOf(conta.getNumeroDaConta().getDigitoDaConta().toString()) : Integer.valueOf(this.calculeDigitoVerificador(conta.getNumeroDaConta().getCodigoDaConta().toString()));
        this.add(new FixedField<Integer>(conta.getNumeroDaConta().getCodigoDaConta(), (Integer)6, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(dVCodigoDoCedente, (Integer)1));
        this.add(new FixedField<String>(nossoNumero.substring(0, 3), 3));
        if (conta.getCarteira().isComRegistro()) {
            this.add(new FixedField<Integer>(Integer.valueOf(1), (Integer)1));
        } else {
            this.add(new FixedField<Integer>(Integer.valueOf(2), (Integer)1));
        }
        this.add(new FixedField<String>(nossoNumero.substring(3, 6), 3));
        this.add(new FixedField<Integer>(Integer.valueOf(4), (Integer)1));
        this.add(new FixedField<String>(nossoNumero.substring(6, 15), 9));
        this.add(new FixedField<Integer>(Integer.valueOf(this.calculeDigitoVerificador(this.gereCampoLivre())), (Integer)1));
    }

    private String gereCampoLivre() {
        return this.writeFields();
    }

    private int calculeDigitoVerificador(String numeroParaCalculo) {
        int restoDiv11;
        int subResto;
        int soma = Modulo.calculeSomaSequencialMod11(numeroParaCalculo.toString(), 2, 9);
        int dvCampoLivre = soma < Modulo.MOD11 ? Modulo.MOD11 - soma : ((subResto = Modulo.MOD11 - (restoDiv11 = soma % Modulo.MOD11)) > 9 ? 0 : subResto);
        return dvCampoLivre;
    }

    @Override
    protected void addFields(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }

    @Override
    protected void checkValues(Titulo titulo) {
        Exceptions.throwUnsupportedOperationException("AINDA N\u00c3O IMPLEMENTADO!");
    }
}

