/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.bopepo.campolivre;

import org.jrimum.bopepo.campolivre.AbstractCLBancoDeBrasilia;
import org.jrimum.bopepo.parametro.ParametroCECRED;
import org.jrimum.domkee.banco.Titulo;
import org.jrimum.texgit.Fillers;
import org.jrimum.texgit.FixedField;

public class CLCecred
extends AbstractCLBancoDeBrasilia {
    private static final long serialVersionUID = 7075964070090557563L;
    private static final Integer FIELDS_LENGTH = 3;
    private static final Integer CONVENIO_LENGTH = 6;
    private static final Integer NOSSO_NUMERO_LENGTH = 17;
    private static final Integer CARTEIRA_LENGTH = 2;

    protected CLCecred() {
        super(FIELDS_LENGTH);
    }

    @Override
    protected void checkValues(Titulo titulo) {
        CLCecred.checkParametroBancario(titulo, ParametroCECRED.CODIGO_DO_CONVENIO);
        CLCecred.checkParametroBancarioMenorOuIgualQue(titulo, ParametroCECRED.CODIGO_DO_CONVENIO, 999999);
        CLCecred.checkNossoNumero(titulo);
        CLCecred.checkTamanhoDoNossoNumero(titulo, 17);
        CLCecred.checkCarteiraNotNull(titulo);
        CLCecred.checkCodigoDaCarteira(titulo);
        CLCecred.checkCodigoDaCarteiraMenorOuIgualQue(titulo, 99);
    }

    @Override
    protected void addFields(Titulo titulo) {
        this.add(new FixedField<Integer>((Integer)titulo.getParametrosBancarios().getValor(ParametroCECRED.CODIGO_DO_CONVENIO), CONVENIO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<String>(titulo.getNossoNumero(), NOSSO_NUMERO_LENGTH, Fillers.ZERO_LEFT));
        this.add(new FixedField<Integer>(titulo.getContaBancaria().getCarteira().getCodigo(), CARTEIRA_LENGTH, Fillers.ZERO_LEFT));
    }
}

